/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;
import net.lingala.zip4j.util.Zip4jUtil;

public class PBKDF2Engine {
    private PBKDF2Parameters parameters;
    private PRF prf;

    public PBKDF2Engine(PBKDF2Parameters parameters) {
        this(parameters, null);
    }

    public PBKDF2Engine(PBKDF2Parameters parameters, PRF prf) {
        this.parameters = parameters;
        this.prf = prf;
    }

    public byte[] deriveKey(char[] inputPassword, int dkLen, boolean useUtf8ForPassword) {
        if (inputPassword == null) {
            throw new NullPointerException();
        }
        byte[] p2 = Zip4jUtil.convertCharArrayToByteArray(inputPassword, useUtf8ForPassword);
        this.assertPRF(p2);
        if (dkLen == 0) {
            dkLen = this.prf.getHLen();
        }
        return this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), dkLen);
    }

    private void assertPRF(byte[] P2) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(P2);
    }

    private byte[] PBKDF2(PRF prf, byte[] S2, int c2, int dkLen) {
        if (S2 == null) {
            S2 = new byte[]{};
        }
        int hLen = prf.getHLen();
        int l2 = this.ceil(dkLen, hLen);
        int r2 = dkLen - (l2 - 1) * hLen;
        byte[] T2 = new byte[l2 * hLen];
        int ti_offset = 0;
        for (int i2 = 1; i2 <= l2; ++i2) {
            this._F(T2, ti_offset, prf, S2, c2, i2);
            ti_offset += hLen;
        }
        if (r2 < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T2, 0, DK, 0, dkLen);
            return DK;
        }
        return T2;
    }

    private int ceil(int a2, int b2) {
        int m2 = 0;
        if (a2 % b2 > 0) {
            m2 = 1;
        }
        return a2 / b2 + m2;
    }

    private void _F(byte[] dest, int offset, PRF prf, byte[] S2, int c2, int blockIndex) {
        int hLen = prf.getHLen();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S2.length + 4];
        System.arraycopy(S2, 0, U_i, 0, S2.length);
        this.INT(U_i, S2.length, blockIndex);
        for (int i2 = 0; i2 < c2; ++i2) {
            U_i = prf.doFinal(U_i);
            this.xor(U_r, U_i);
        }
        System.arraycopy(U_r, 0, dest, offset, hLen);
    }

    private void xor(byte[] dest, byte[] src) {
        for (int i2 = 0; i2 < dest.length; ++i2) {
            int n2 = i2;
            dest[n2] = (byte)(dest[n2] ^ src[i2]);
        }
    }

    protected void INT(byte[] dest, int offset, int i2) {
        dest[offset] = (byte)(i2 / 0x1000000);
        dest[offset + 1] = (byte)(i2 / 65536);
        dest[offset + 2] = (byte)(i2 / 256);
        dest[offset + 3] = (byte)i2;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters parameters) {
        this.parameters = parameters;
    }

    public void setPseudoRandomFunction(PRF prf) {
        this.prf = prf;
    }
}

