/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.lingala.zip4j.crypto.PBKDF2.PRF;

public class MacBasedPRF
implements PRF {
    private Mac mac;
    private int hLen;
    private String macAlgorithm;
    private ByteArrayOutputStream macCache;

    public MacBasedPRF(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        this.macCache = new ByteArrayOutputStream(4096);
        try {
            this.mac = Mac.getInstance(macAlgorithm);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public byte[] doFinal(byte[] M2) {
        if (this.macCache.size() > 0) {
            this.doMacUpdate(0);
        }
        return this.mac.doFinal(M2);
    }

    public byte[] doFinal() {
        return this.doFinal(0);
    }

    public byte[] doFinal(int numberOfBytesToPushbackForMac) {
        if (this.macCache.size() > 0) {
            this.doMacUpdate(numberOfBytesToPushbackForMac);
        }
        return this.mac.doFinal();
    }

    @Override
    public int getHLen() {
        return this.hLen;
    }

    @Override
    public void init(byte[] P2) {
        try {
            this.mac.init(new SecretKeySpec(P2, this.macAlgorithm));
        }
        catch (InvalidKeyException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void update(byte[] u2) {
        this.update(u2, 0, u2.length);
    }

    public void update(byte[] u2, int start, int len) {
        try {
            if (this.macCache.size() + len > 4096) {
                this.doMacUpdate(0);
            }
            this.macCache.write(u2, start, len);
        }
        catch (IllegalStateException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void doMacUpdate(int numberOfBytesToPushBack) {
        byte[] macBytes = this.macCache.toByteArray();
        int numberOfBytesToRead = macBytes.length - numberOfBytesToPushBack;
        for (int i2 = 0; i2 < numberOfBytesToRead; i2 += 16) {
            int updateLength = i2 + 16 <= numberOfBytesToRead ? 16 : numberOfBytesToRead - i2;
            this.mac.update(macBytes, i2, updateLength);
        }
        this.macCache.reset();
    }
}

