/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils.requestbody;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.dv8tion.jda.internal.utils.requestbody.TypedBody;
import okhttp3.MediaType;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class BufferedRequestBody
extends TypedBody<BufferedRequestBody> {
    private final Source source;
    private byte[] data;

    public BufferedRequestBody(Source source, MediaType type) {
        super(type);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public BufferedRequestBody withType(@Nonnull MediaType type) {
        if (type.equals(this.type)) {
            return this;
        }
        Source source = this.source;
        synchronized (source) {
            BufferedRequestBody copy = new BufferedRequestBody(this.source, type);
            copy.data = this.data;
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@Nonnull BufferedSink sink) throws IOException {
        Source source = this.source;
        synchronized (source) {
            if (this.data != null) {
                sink.write(this.data);
                return;
            }
            try (BufferedSource s2 = Okio.buffer(this.source);){
                this.data = s2.readByteArray();
                sink.write(this.data);
            }
        }
    }

    protected void finalize() {
        IOUtil.silentClose(this.source);
    }
}

