/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils.compress;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.dv8tion.jda.api.utils.Compression;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.dv8tion.jda.internal.utils.JDALogger;
import net.dv8tion.jda.internal.utils.compress.Decompressor;

public class ZlibDecompressor
implements Decompressor {
    private static final int Z_SYNC_FLUSH = 65535;
    private final int maxBufferSize;
    private final Inflater inflater = new Inflater();
    private ByteBuffer flushBuffer = null;
    private SoftReference<ByteArrayOutputStream> decompressBuffer = null;

    public ZlibDecompressor(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    private SoftReference<ByteArrayOutputStream> newDecompressBuffer() {
        return new SoftReference<ByteArrayOutputStream>(new ByteArrayOutputStream(Math.min(1024, this.maxBufferSize)));
    }

    private ByteArrayOutputStream getDecompressBuffer() {
        ByteArrayOutputStream buffer;
        if (this.decompressBuffer == null) {
            this.decompressBuffer = this.newDecompressBuffer();
        }
        if ((buffer = this.decompressBuffer.get()) == null) {
            buffer = new ByteArrayOutputStream(Math.min(1024, this.maxBufferSize));
            this.decompressBuffer = new SoftReference<ByteArrayOutputStream>(buffer);
        }
        return buffer;
    }

    private boolean isFlush(byte[] data) {
        if (data.length < 4) {
            return false;
        }
        int suffix = IOUtil.getIntBigEndian(data, data.length - 4);
        return suffix == 65535;
    }

    private void buffer(byte[] data) {
        if (this.flushBuffer == null) {
            this.flushBuffer = ByteBuffer.allocate(data.length * 2);
        }
        if (this.flushBuffer.capacity() < data.length + this.flushBuffer.position()) {
            this.flushBuffer.flip();
            this.flushBuffer = IOUtil.reallocate(this.flushBuffer, (this.flushBuffer.capacity() + data.length) * 2);
        }
        this.flushBuffer.put(data);
    }

    private Object lazy(byte[] data) {
        return JDALogger.getLazyString(() -> Arrays.toString(data));
    }

    @Override
    public Compression getType() {
        return Compression.ZLIB;
    }

    @Override
    public void reset() {
        this.inflater.reset();
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] decompress(byte[] data) throws DataFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

