/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class JDALogger {
    public static final String DISABLE_FALLBACK_PROPERTY_NAME = "net.dv8tion.jda.disableFallbackLogger";
    public static final boolean SLF4J_ENABLED;
    private static boolean disableFallback;
    private static final MethodHandle fallbackLoggerConstructor;
    private static final Map<String, Logger> LOGS;

    private JDALogger() {
    }

    public static void setFallbackLoggerEnabled(boolean enabled) {
        disableFallback = !enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLog(String name) {
        Map<String, Logger> map = LOGS;
        synchronized (map) {
            if (SLF4J_ENABLED || disableFallback) {
                return LoggerFactory.getLogger(name);
            }
            return JDALogger.newFallbackLogger(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLog(Class<?> clazz) {
        Map<String, Logger> map = LOGS;
        synchronized (map) {
            if (SLF4J_ENABLED || disableFallback) {
                return LoggerFactory.getLogger(clazz);
            }
            return JDALogger.newFallbackLogger(clazz.getSimpleName());
        }
    }

    private static void printFallbackWarning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger newFallbackLogger(String name) {
        if (disableFallback || fallbackLoggerConstructor == null) {
            return NOPLogger.NOP_LOGGER;
        }
        try {
            Map<String, Logger> map = LOGS;
            synchronized (map) {
                if (LOGS.containsKey(name)) {
                    return LOGS.get(name);
                }
                Logger logger = fallbackLoggerConstructor.invoke(name);
                boolean isFirstFallback = LOGS.isEmpty();
                LOGS.put(name, logger);
                if (isFirstFallback) {
                    JDALogger.printFallbackWarning();
                }
                return logger;
            }
        }
        catch (Throwable e2) {
            throw new IllegalStateException("Failed to initialize fallback logger", e2);
        }
    }

    public static Object getLazyString(final LazyEvaluation lazyLambda) {
        return new Object(){

            public String toString() {
                try {
                    return lazyLambda.getString();
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    return "Error while evaluating lazy String... " + sw;
                }
            }
        };
    }

    static {
        disableFallback = Boolean.getBoolean(DISABLE_FALLBACK_PROPERTY_NAME);
        boolean hasLoggerImpl = false;
        try {
            Class<?> provider = Class.forName("org.slf4j.spi.SLF4JServiceProvider");
            hasLoggerImpl = ServiceLoader.load(provider).iterator().hasNext();
        }
        catch (ClassNotFoundException ignored) {
            disableFallback = true;
        }
        SLF4J_ENABLED = hasLoggerImpl;
        Object constructor = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError linkageError) {
            // empty catch block
        }
        fallbackLoggerConstructor = constructor;
        LOGS = new HashMap<String, Logger>();
    }

    @FunctionalInterface
    public static interface LazyEvaluation {
        public String getString() throws Exception;
    }
}

