/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import java.util.EnumSet;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.ICategorizableChannel;
import net.dv8tion.jda.api.entities.channel.attribute.IPositionableChannel;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

public class ChannelUtil {
    public static final EnumSet<ChannelType> SLOWMODE_SUPPORTED = EnumSet.of(ChannelType.TEXT, new ChannelType[]{ChannelType.FORUM, ChannelType.MEDIA, ChannelType.GUILD_PUBLIC_THREAD, ChannelType.GUILD_NEWS_THREAD, ChannelType.GUILD_PRIVATE_THREAD, ChannelType.STAGE, ChannelType.VOICE});
    public static final EnumSet<ChannelType> NSFW_SUPPORTED = EnumSet.of(ChannelType.TEXT, new ChannelType[]{ChannelType.VOICE, ChannelType.FORUM, ChannelType.MEDIA, ChannelType.NEWS, ChannelType.STAGE});
    public static final EnumSet<ChannelType> TOPIC_SUPPORTED = EnumSet.of(ChannelType.TEXT, ChannelType.FORUM, ChannelType.MEDIA, ChannelType.NEWS);
    public static final EnumSet<ChannelType> POST_CONTAINERS = EnumSet.of(ChannelType.FORUM, ChannelType.MEDIA);
    public static final EnumSet<ChannelType> THREAD_CONTAINERS = EnumSet.of(ChannelType.TEXT, ChannelType.NEWS, ChannelType.FORUM, ChannelType.MEDIA);

    public static <T extends Channel> T safeChannelCast(Object instance, Class<T> toObjectClass) {
        if (toObjectClass.isInstance(instance)) {
            return (T)((Channel)toObjectClass.cast(instance));
        }
        String cleanedClassName = instance.getClass().getSimpleName().replace("Impl", "");
        throw new IllegalStateException(Helpers.format("Cannot convert channel of type %s to %s!", cleanedClassName, toObjectClass.getSimpleName()));
    }

    public static int compare(GuildChannel a2, GuildChannel b2) {
        Category otherParent;
        ThreadChannel otherThread;
        Checks.notNull(b2, "Channel");
        ThreadChannel thisThread = a2 instanceof ThreadChannel ? (ThreadChannel)a2 : null;
        ThreadChannel threadChannel = otherThread = b2 instanceof ThreadChannel ? (ThreadChannel)b2 : null;
        if (thisThread != null && otherThread == null) {
            if (thisThread.getParentChannel().getIdLong() == b2.getIdLong()) {
                return 1;
            }
            return thisThread.getParentChannel().compareTo(b2);
        }
        if (thisThread == null && otherThread != null) {
            if (otherThread.getParentChannel().getIdLong() == a2.getIdLong()) {
                return -1;
            }
            return a2.compareTo(otherThread.getParentChannel());
        }
        if (thisThread != null) {
            if (thisThread.getParentChannel().getIdLong() == otherThread.getParentChannel().getIdLong()) {
                return Long.compare(b2.getIdLong(), a2.getIdLong());
            }
            return thisThread.getParentChannel().compareTo(otherThread.getParentChannel());
        }
        Category thisParent = a2 instanceof ICategorizableChannel ? ((ICategorizableChannel)a2).getParentCategory() : null;
        Category category = otherParent = b2 instanceof ICategorizableChannel ? ((ICategorizableChannel)b2).getParentCategory() : null;
        if (thisParent != null && otherParent == null) {
            if (b2 instanceof Category) {
                if (b2.getIdLong() == thisParent.getIdLong()) {
                    return 1;
                }
                return thisParent.compareTo(b2);
            }
            return 1;
        }
        if (thisParent == null && otherParent != null) {
            if (a2 instanceof Category) {
                if (a2.getIdLong() == otherParent.getIdLong()) {
                    return -1;
                }
                return a2.compareTo(otherParent);
            }
            return -1;
        }
        if (thisParent != null && !thisParent.equals(otherParent)) {
            return thisParent.compareTo(otherParent);
        }
        if (a2.getType().getSortBucket() != b2.getType().getSortBucket()) {
            return Integer.compare(a2.getType().getSortBucket(), b2.getType().getSortBucket());
        }
        if (b2 instanceof IPositionableChannel && a2 instanceof IPositionableChannel) {
            IPositionableChannel oPositionableChannel = (IPositionableChannel)b2;
            IPositionableChannel thisPositionableChannel = (IPositionableChannel)a2;
            if (thisPositionableChannel.getPositionRaw() != oPositionableChannel.getPositionRaw()) {
                return Integer.compare(thisPositionableChannel.getPositionRaw(), oPositionableChannel.getPositionRaw());
            }
        }
        return Long.compareUnsigned(a2.getIdLong(), b2.getIdLong());
    }
}

