/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.audio;

import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.dv8tion.jda.internal.audio.AudioConnection;
import net.dv8tion.jda.internal.audio.AudioPacket;

public class Decoder {
    protected int ssrc;
    protected char lastSeq;
    protected int lastTimestamp;
    protected PointerByReference opusDecoder;

    protected Decoder(int ssrc) {
        this.ssrc = ssrc;
        this.lastSeq = (char)65535;
        this.lastTimestamp = -1;
        IntBuffer error = IntBuffer.allocate(1);
    }

    public boolean isInOrder(char newSeq) {
        return this.lastSeq == '\uffff' || newSeq > this.lastSeq || this.lastSeq - newSeq > 10;
    }

    public boolean wasPacketLost(char newSeq) {
        return newSeq > this.lastSeq + '\u0001';
    }

    public short[] decodeFromOpus(AudioPacket decryptedPacket) {
        int result;
        ShortBuffer decoded = ShortBuffer.allocate(4096);
        if (decryptedPacket == null) {
            result = -1;
            this.lastSeq = (char)65535;
            this.lastTimestamp = -1;
        } else {
            this.lastSeq = decryptedPacket.getSequence();
            this.lastTimestamp = decryptedPacket.getTimestamp();
            ByteBuffer encodedAudio = decryptedPacket.getEncodedAudio();
            int length = encodedAudio.remaining();
            int offset = encodedAudio.arrayOffset() + encodedAudio.position();
            byte[] buf = new byte[length];
            byte[] data = encodedAudio.array();
            System.arraycopy(data, offset, buf, 0, length);
            result = -1;
        }
        if (result < 0) {
            this.handleDecodeError(result);
            return null;
        }
        short[] audio = new short[result * 2];
        decoded.get(audio);
        return audio;
    }

    private void handleDecodeError(int result) {
        StringBuilder b2 = new StringBuilder("Decoder failed to decode audio from user with code ");
        AudioConnection.LOG.debug("{}", (Object)b2);
    }

    protected synchronized void close() {
        if (this.opusDecoder != null) {
            this.opusDecoder = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

