/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.audio;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.utils.data.DataArray;

public enum AudioEncryption {
    AEAD_AES256_GCM_RTPSIZE,
    AEAD_XCHACHA20_POLY1305_RTPSIZE;

    private final String key = this.name().toLowerCase();

    public String getKey() {
        return this.key;
    }

    public static AudioEncryption getPreferredMode(DataArray array) {
        AudioEncryption encryption = null;
        for (Object o2 : array) {
            try {
                String name = String.valueOf(o2).toUpperCase();
                AudioEncryption e2 = AudioEncryption.valueOf(name);
                if (encryption != null && e2.ordinal() >= encryption.ordinal()) continue;
                encryption = e2;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return encryption;
    }

    public static EnumSet<AudioEncryption> fromArray(DataArray modes) {
        return modes.stream(DataArray::getString).map(mode -> mode.toLowerCase(Locale.ROOT)).map(AudioEncryption::forMode).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(AudioEncryption.class)));
    }

    public static AudioEncryption forMode(String mode) {
        switch (mode) {
            case "aead_aes256_gcm_rtpsize": {
                return AEAD_AES256_GCM_RTPSIZE;
            }
            case "aead_xchacha20_poly1305_rtpsize": {
                return AEAD_XCHACHA20_POLY1305_RTPSIZE;
            }
        }
        return null;
    }
}

