/*
 * Decompiled with CFR 0.152.
 */
package com.appunity.logger;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.appunity.logger.CipherRollingFileAppender;
import com.appunity.logger.LogcatAppender;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;

public class LoggerConfig {
    public static final String PATTERN = "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p --- [%t] %-40.40logger{39}- %msg%n";

    /*
     * WARNING - void declaration
     */
    public static void configure(String logDir, SecretKey secretKey) {
        void var1_1;
        String string;
        LoggerConfig.configure(false, string, (SecretKey)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void configure(boolean logcat, String logDir, SecretKey secretKey) {
        boolean bl;
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger("ROOT");
        if (LoggerConfig.isDalvikVm() && bl) {
            loggerContext.reset();
            LogcatAppender logcatAppender = LoggerConfig.createLogcatAppender(loggerContext);
            logger.addAppender(logcatAppender);
        }
        if (logDir != null && logDir.length() > 0) {
            void var1_3;
            void var2_4;
            RollingFileAppender<ILoggingEvent> rollingFileAppender = secretKey != null ? LoggerConfig.createCipherFileAppender(loggerContext, logDir, (SecretKey)var2_4) : LoggerConfig.createFileAppender(loggerContext, (String)var1_3);
            logger.addAppender(rollingFileAppender);
        }
    }

    private static boolean isDalvikVm() {
        return "Dalvik".equals(System.getProperty("java.vm.name")) || System.getProperty("java.vendor").contains("Android");
    }

    public static LogcatAppender createLogcatAppender(LoggerContext lc) {
        LoggerContext loggerContext;
        LogcatAppender logcatAppender = new LogcatAppender();
        logcatAppender.setContext(lc);
        logcatAppender.setName("logcat");
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext(lc);
        patternLayoutEncoder.setPattern("[%thread] %msg%n");
        patternLayoutEncoder.start();
        logcatAppender.setEncoder(patternLayoutEncoder);
        patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext(loggerContext);
        patternLayoutEncoder.setPattern("%class{0}");
        patternLayoutEncoder.start();
        logcatAppender.setTagEncoder(patternLayoutEncoder);
        logcatAppender.start();
        return logcatAppender;
    }

    public static RollingFileAppender<ILoggingEvent> createCipherFileAppender(LoggerContext context, String logDir, SecretKey secretKey) {
        LoggerContext loggerContext;
        PatternLayoutEncoder patternLayoutEncoder;
        CipherRollingFileAppender<ILoggingEvent> cipherRollingFileAppender;
        cipherRollingFileAppender = new CipherRollingFileAppender<ILoggingEvent>((SecretKey)((Object)cipherRollingFileAppender));
        cipherRollingFileAppender.setAppend(true);
        cipherRollingFileAppender.setName("CipherAppender");
        cipherRollingFileAppender.setContext(context);
        cipherRollingFileAppender.setFile(logDir + "/log.bin");
        TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
        timeBasedRollingPolicy.setFileNamePattern((String)((Object)patternLayoutEncoder) + "/log.%d.bin");
        timeBasedRollingPolicy.setMaxHistory(7);
        timeBasedRollingPolicy.setParent(cipherRollingFileAppender);
        timeBasedRollingPolicy.setContext(context);
        timeBasedRollingPolicy.start();
        cipherRollingFileAppender.setRollingPolicy(timeBasedRollingPolicy);
        patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern(PATTERN);
        patternLayoutEncoder.setContext(loggerContext);
        patternLayoutEncoder.start();
        cipherRollingFileAppender.setEncoder(patternLayoutEncoder);
        cipherRollingFileAppender.start();
        return cipherRollingFileAppender;
    }

    public static RollingFileAppender<ILoggingEvent> createFileAppender(LoggerContext context, String logDir) {
        LoggerContext loggerContext;
        PatternLayoutEncoder patternLayoutEncoder;
        RollingFileAppender<ILoggingEvent> rollingFileAppender = new RollingFileAppender<ILoggingEvent>();
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setName("RollingFileAppender");
        rollingFileAppender.setContext(context);
        rollingFileAppender.setFile(logDir + "/log.txt");
        TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
        timeBasedRollingPolicy.setFileNamePattern((String)((Object)patternLayoutEncoder) + "/log.%d.txt");
        timeBasedRollingPolicy.setMaxHistory(7);
        timeBasedRollingPolicy.setParent(rollingFileAppender);
        timeBasedRollingPolicy.setContext(context);
        timeBasedRollingPolicy.start();
        rollingFileAppender.setRollingPolicy(timeBasedRollingPolicy);
        patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern(PATTERN);
        patternLayoutEncoder.setContext(loggerContext);
        patternLayoutEncoder.start();
        rollingFileAppender.setEncoder(patternLayoutEncoder);
        rollingFileAppender.start();
        return rollingFileAppender;
    }
}

