/*
 * Decompiled with CFR 0.152.
 */
package com.appunity.logger;

import android.util.Log;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;

public class LogcatAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int MAX_TAG_LENGTH = 23;
    private PatternLayoutEncoder encoder = null;
    private PatternLayoutEncoder tagEncoder = null;
    private boolean checkLoggable = false;

    @Override
    public void start() {
        if (this.encoder == null || this.encoder.getLayout() == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.tagEncoder != null) {
            PatternLayout patternLayout = this.tagEncoder.getLayout();
            if (patternLayout == null) {
                this.addError("No tag layout set for the appender named [" + this.name + "].");
                return;
            }
            if (patternLayout instanceof PatternLayout) {
                String string = this.tagEncoder.getPattern();
                if (!string.contains("%nopex")) {
                    this.tagEncoder.stop();
                    this.tagEncoder.setPattern(string + "%nopex");
                    this.tagEncoder.start();
                }
                patternLayout = patternLayout;
                patternLayout.setPostCompileProcessor(null);
            }
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        String string = this.getTag(event);
        switch (event.getLevel().levelInt) {
            case -2147483648: 
            case 5000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)2)) break;
                Log.v((String)string, (String)this.encoder.getLayout().doLayout(event));
                return;
            }
            case 10000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)3)) break;
                Log.d((String)string, (String)this.encoder.getLayout().doLayout(event));
                return;
            }
            case 20000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)4)) break;
                Log.i((String)string, (String)this.encoder.getLayout().doLayout(event));
                return;
            }
            case 30000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)5)) break;
                Log.w((String)string, (String)this.encoder.getLayout().doLayout(event));
                return;
            }
            case 40000: {
                void var1_1;
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)6)) break;
                Log.e((String)string, (String)this.encoder.getLayout().doLayout(var1_1));
            }
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoder(PatternLayoutEncoder encoder) {
        void var1_1;
        this.encoder = var1_1;
    }

    public PatternLayoutEncoder getTagEncoder() {
        return this.tagEncoder;
    }

    /*
     * WARNING - void declaration
     */
    public void setTagEncoder(PatternLayoutEncoder encoder) {
        void var1_1;
        this.tagEncoder = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckLoggable(boolean enable) {
        void var1_1;
        this.checkLoggable = var1_1;
    }

    public boolean getCheckLoggable() {
        return this.checkLoggable;
    }

    protected String getTag(ILoggingEvent event) {
        String string;
        String string2 = string = this.tagEncoder != null ? this.tagEncoder.getLayout().doLayout(event) : string.getLoggerName();
        if (this.checkLoggable && string.length() > 23) {
            string = string.substring(0, 22) + "*";
        }
        return string;
    }
}

