/*
 * Decompiled with CFR 0.152.
 */
package com.appunity.logger;

import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class CipherRollingFileAppender<E>
extends RollingFileAppender<E> {
    public static final String DES_ECB_NO_PADDING = "DES/ECB/NoPadding";
    private final SecretKey secretKey;

    /*
     * WARNING - void declaration
     */
    public CipherRollingFileAppender(SecretKey secretKey) {
        void var1_1;
        this.secretKey = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.lock.lock();
        try {
            this.closeOutputStream();
            PaddingOutputStream paddingOutputStream = null;
            try {
                Object object = Cipher.getInstance(DES_ECB_NO_PADDING);
                ((Cipher)object).init(1, this.secretKey);
                object = new CipherOutputStream(outputStream, (Cipher)object);
                paddingOutputStream = new PaddingOutputStream((OutputStream)object, 8);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
                noSuchAlgorithmException.printStackTrace();
            }
            catch (InvalidKeyException invalidKeyException) {
                InvalidKeyException invalidKeyException2 = invalidKeyException;
                invalidKeyException.printStackTrace();
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                NoSuchPaddingException noSuchPaddingException2 = noSuchPaddingException;
                noSuchPaddingException.printStackTrace();
            }
            if (paddingOutputStream == null) {
                void var1_1;
                super.setOutputStream((OutputStream)var1_1);
            } else {
                super.setOutputStream(paddingOutputStream);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PaddingOutputStream
    extends FilterOutputStream {
        private final long size;
        protected long count;

        /*
         * WARNING - void declaration
         */
        public PaddingOutputStream(OutputStream out, int size) {
            super((OutputStream)var1_1);
            void var2_2;
            void var1_1;
            this.size = (long)var2_2;
            this.count = 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int b2) throws IOException {
            void var1_1;
            ++this.count;
            super.write((int)var1_1);
        }

        @Override
        public synchronized void flush() throws IOException {
            for (long i2 = this.count % this.size; i2 != 0L && i2 < this.size; ++i2) {
                super.write(0);
            }
            this.count = 0L;
            super.flush();
        }
    }
}

