/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class StatusPrinter {
    private static PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public static void printInCaseOfErrorsOrWarnings(Context context) {
        StatusPrinter.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static void printInCaseOfErrorsOrWarnings(Context context, long threshold) {
        Object object;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(threshold) > 0) {
            void var1_1;
            StatusPrinter.print(statusManager, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void print(StatusManager sm, long threshold) {
        void var1_1;
        List<Status> list;
        StringBuilder stringBuilder = new StringBuilder();
        list = StatusUtil.filterStatusListByTimeThreshold(list.getCopyOfStatusList(), (long)var1_1);
        StatusPrinter.buildStrFromStatusList(stringBuilder, list);
        ps.println(stringBuilder.toString());
    }

    private static void buildStrFromStatusList(StringBuilder sb, List<Status> statusList) {
        Iterator iterator;
        if (statusList == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status status = (Status)iterator.next();
            StatusPrinter.buildStr(sb, "", status);
        }
    }

    private static void appendThrowable(StringBuilder sb, Throwable t2) {
        String[] stringArray = ThrowableToStringArray.convert(t2);
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(string).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder sb, String indentation, Status s2) {
        Object object;
        String string = s2.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (cachingDateFormat != null) {
            object = cachingDateFormat.format(s2.getDate());
            sb.append((String)object).append(" ");
        }
        sb.append(string).append(s2).append(CoreConstants.LINE_SEPARATOR);
        if (s2.getThrowable() != null) {
            StatusPrinter.appendThrowable(sb, s2.getThrowable());
        }
        if (s2.hasChildren()) {
            Status status;
            object = status.iterator();
            while (object.hasNext()) {
                status = (Status)object.next();
                StatusPrinter.buildStr(sb, indentation + "  ", status);
            }
        }
    }
}

