/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.OptionHelper;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Loader {
    private static boolean ignoreTCL = false;
    private static boolean HAS_GET_CLASS_LOADER_PERMISSION = false;

    public static URL getResource(String resource, ClassLoader classLoader) {
        try {
            String string;
            return classLoader.getResource(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static URL getResourceBySelfClassLoader(String resource) {
        return Loader.getResource(resource, Loader.getClassLoaderOfClass(Loader.class));
    }

    public static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoaderOfObject(Object o2) {
        Object object;
        if (o2 == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        return Loader.getClassLoaderOfClass(object.getClass());
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(clazz);
        }
        try {
            return Loader.getTCL().loadClass(clazz);
        }
        catch (Throwable throwable) {
            String string;
            return Class.forName(string);
        }
    }

    static {
        String string = OptionHelper.getSystemProperty("logback.ignoreTCL", null);
        if (string != null) {
            ignoreTCL = OptionHelper.toBoolean(string, true);
        }
        HAS_GET_CLASS_LOADER_PERMISSION = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public final Boolean run() {
                try {
                    AccessController.checkPermission(new RuntimePermission("getClassLoader"));
                    return Boolean.TRUE;
                }
                catch (SecurityException securityException) {
                    return Boolean.FALSE;
                }
            }
        });
    }
}

