/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class StatusBase
implements Status {
    private static final List<Status> EMPTY_LIST = new ArrayList<Status>(0);
    int level;
    final String message;
    final Object origin;
    List<Status> childrenList;
    Throwable throwable;
    long date;

    /*
     * WARNING - void declaration
     */
    StatusBase(int level, String msg, Object origin) {
        this((int)var1_1, (String)var2_2, var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    StatusBase(int level, String msg, Object origin, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.level = var1_1;
        this.message = var2_2;
        this.origin = var3_3;
        this.throwable = t2;
        this.date = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void add(Status child) {
        void var1_1;
        if (child == null) {
            throw new NullPointerException("Null values are not valid Status.");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Status>();
        }
        this.childrenList.add((Status)var1_1);
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.childrenList != null && this.childrenList.size() > 0;
    }

    @Override
    public synchronized Iterator<Status> iterator() {
        if (this.childrenList != null) {
            return this.childrenList.iterator();
        }
        return EMPTY_LIST.iterator();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public synchronized int getEffectiveLevel() {
        int n2 = this.level;
        Iterator<Status> iterator = this.iterator();
        while (iterator.hasNext()) {
            Status status = iterator.next();
            int n3 = status.getEffectiveLevel();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public Long getDate() {
        return this.date;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getEffectiveLevel()) {
            case 0: {
                stringBuilder.append("INFO");
                break;
            }
            case 1: {
                stringBuilder.append("WARN");
                break;
            }
            case 2: {
                stringBuilder.append("ERROR");
            }
        }
        if (this.origin != null) {
            stringBuilder.append(" in ");
            stringBuilder.append(this.origin);
            stringBuilder.append(" -");
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.message);
        if (this.throwable != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.throwable);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31 + this.level;
        n2 = n2 * 31 + (this.message == null ? 0 : this.message.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        StatusBase statusBase;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        statusBase = statusBase;
        if (this.level != statusBase.level) {
            return false;
        }
        return !(this.message == null ? statusBase.message != null : !this.message.equals(statusBase.message));
    }
}

