/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    /*
     * WARNING - void declaration
     */
    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        void var1_1;
        void var2_2;
        this.fileNamePattern = fileNamePattern;
        this.rc = var2_2;
        this.parentClean = this.computeParentCleaningFlag((FileNamePattern)var1_1);
    }

    public void clean(Date now) {
        long l2 = now.getTime();
        int n2 = this.computeElapsedPeriodsSinceLastClean(l2);
        this.lastHeartBeat = l2;
        if (n2 > 1) {
            this.addInfo("Multiple periods, i.e. " + n2 + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getPeriodOffsetForDeletionTarget() - i2;
            Date date = this.rc.getEndOfNextNthPeriod(now, n3);
            this.cleanPeriod(date);
        }
    }

    protected File[] getFilesInPeriod(Date dateOfPeriodToClean) {
        Object object;
        object = this.fileNamePattern.convert(object);
        if (this.fileExistsAndIsFile((File)(object = new File((String)object)))) {
            return new File[]{object};
        }
        return new File[0];
    }

    /*
     * WARNING - void declaration
     */
    private boolean fileExistsAndIsFile(File file2Delete) {
        void var1_1;
        return file2Delete.exists() && var1_1.isFile();
    }

    public void cleanPeriod(Date dateOfPeriodToClean) {
        File[] fileArray;
        Object object = fileArray = this.getFilesInPeriod((Date)fileArray);
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = object[i2];
            this.addInfo("deleting " + file);
            file.delete();
        }
        if (this.parentClean && fileArray.length > 0) {
            object = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty((File)object);
        }
    }

    void capTotalSize(Date now) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.maxHistory; ++i2) {
            File[] fileArray = this.rc.getEndOfNextNthPeriod(now, -i2);
            fileArray = this.getFilesInPeriod((Date)fileArray);
            this.descendingSortByLastModified(fileArray);
            for (File file : fileArray) {
                long l4 = file.length();
                if (l2 + l4 > this.totalSizeCap) {
                    this.addInfo("Deleting [" + file + "] of size " + new FileSize(l4));
                    l3 += l4;
                    file.delete();
                }
                l2 += l4;
            }
        }
        this.addInfo("Removed  " + new FileSize(l3) + " of files");
    }

    private void descendingSortByLastModified(File[] matchingFileArray) {
        Arrays.sort(matchingFileArray, new Comparator<File>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(File f1, File f2) {
                void var2_2;
                long l2;
                long l3 = f1.lastModified();
                if (l3 == (l2 = var2_2.lastModified())) {
                    return 0;
                }
                if (l2 < l3) {
                    return -1;
                }
                return 1;
            }
        });
    }

    File getParentDir(File file) {
        File file2 = file.getAbsoluteFile();
        file2 = file2.getParentFile();
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    int computeElapsedPeriodsSinceLastClean(long nowInMillis) {
        long l2;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            long l3 = nowInMillis;
            l2 = this.rc.periodBarriersCrossed(l3, l3 + 2764800000L);
            l2 = Math.min(l2, 336L);
        } else {
            void var1_1;
            l2 = this.rc.periodBarriersCrossed(this.lastHeartBeat, (long)var1_1);
        }
        return (int)l2;
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> converter;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = ((FileNamePattern)((Object)converter)).headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            if (converter instanceof LiteralConverter && ((String)((Object)(dateTokenConverter = converter.convert(null)))).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void removeFolderIfEmpty(File dir) {
        void var1_1;
        this.removeFolderIfEmpty((File)var1_1, 0);
    }

    private void removeFolderIfEmpty(File dir, int depth) {
        while (true) {
            if (depth >= 3) {
                return;
            }
            if (!dir.isDirectory() || !FileFilterUtil.isEmptyDirectory(dir)) break;
            this.addInfo("deleting folder [" + dir + "]");
            dir.delete();
            ++depth;
            dir = dir.getParentFile();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxHistory(int maxHistory) {
        void var1_1;
        this.maxHistory = var1_1;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTotalSizeCap(long totalSizeCap) {
        void var1_1;
        this.totalSizeCap = var1_1;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date now) {
        Object object;
        object = new ArhiveRemoverRunnable((Date)object);
        ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
        object = scheduledExecutorService.submit((Runnable)object);
        return object;
    }

    public class ArhiveRemoverRunnable
    implements Runnable {
        Date now;

        /*
         * WARNING - void declaration
         */
        ArhiveRemoverRunnable(Date now) {
            void var2_2;
            this.now = var2_2;
        }

        @Override
        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
            if (TimeBasedArchiveRemover.this.totalSizeCap != 0L && TimeBasedArchiveRemover.this.totalSizeCap > 0L) {
                TimeBasedArchiveRemover.this.capTotalSize(this.now);
            }
        }
    }
}

