/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    String datePattern;

    /*
     * WARNING - void declaration
     */
    public RollingCalendar(String datePattern) {
        void var1_1;
        this.datePattern = var1_1;
        this.periodicityType = this.computePeriodicityType();
    }

    /*
     * WARNING - void declaration
     */
    public RollingCalendar(String datePattern, TimeZone tz, Locale locale) {
        super((TimeZone)var2_2, (Locale)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.datePattern = var1_1;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType computePeriodicityType() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIMEZONE, Locale.getDefault());
        Date date = new Date(0L);
        if (this.datePattern != null) {
            PeriodicityType[] periodicityTypeArray = PeriodicityType.VALID_ORDERED_LIST;
            int n2 = PeriodicityType.VALID_ORDERED_LIST.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                PeriodicityType periodicityType = periodicityTypeArray[i2];
                Object object = new SimpleDateFormat(this.datePattern);
                ((DateFormat)object).setTimeZone(GMT_TIMEZONE);
                String string = ((DateFormat)object).format(date);
                Date date2 = RollingCalendar.innerGetEndOfThisPeriod(gregorianCalendar, periodicityType, date);
                object = ((DateFormat)object).format(date2);
                if (string == null || object == null || string.equals(object)) continue;
                return periodicityType;
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean collision(long delta) {
        void var1_1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Object object = new Date(0L);
        object = simpleDateFormat.format((Date)object);
        Object object2 = new Date((long)var1_1);
        object2 = simpleDateFormat.format((Date)object2);
        return ((String)object).equals(object2);
    }

    /*
     * WARNING - void declaration
     */
    public void printPeriodicity(ContextAwareBase cab) {
        void var1_1;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                cab.addInfo("Roll-over every millisecond.");
                return;
            }
            case TOP_OF_SECOND: {
                cab.addInfo("Roll-over every second.");
                return;
            }
            case TOP_OF_MINUTE: {
                cab.addInfo("Roll-over every minute.");
                return;
            }
            case TOP_OF_HOUR: {
                cab.addInfo("Roll-over at the top of every hour.");
                return;
            }
            case HALF_DAY: {
                cab.addInfo("Roll-over at midday and midnight.");
                return;
            }
            case TOP_OF_DAY: {
                cab.addInfo("Roll-over at midnight.");
                return;
            }
            case TOP_OF_WEEK: {
                cab.addInfo("Rollover at the start of week.");
                return;
            }
            case TOP_OF_MONTH: {
                cab.addInfo("Rollover at start of every month.");
                return;
            }
        }
        var1_1.addInfo("Unknown periodicity.");
    }

    /*
     * WARNING - void declaration
     */
    public long periodBarriersCrossed(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("Start cannot come before end");
        }
        long l2 = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(start, this.getTimeZone());
        long l3 = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(end, this.getTimeZone());
        long l4 = l3 - l2;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                return l4;
            }
            case TOP_OF_SECOND: {
                return l4 / 1000L;
            }
            case TOP_OF_MINUTE: {
                return l4 / 60000L;
            }
            case TOP_OF_HOUR: {
                return (long)((int)l4) / 3600000L;
            }
            case TOP_OF_DAY: {
                return l4 / 86400000L;
            }
            case TOP_OF_WEEK: {
                return l4 / 604800000L;
            }
            case TOP_OF_MONTH: {
                void var3_2;
                void var1_1;
                return RollingCalendar.diffInMonths((long)var1_1, (long)var3_2);
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }

    /*
     * WARNING - void declaration
     */
    public static int diffInMonths(long startTime, long endTime) {
        void var2_3;
        long l2;
        if (startTime > endTime) {
            throw new IllegalArgumentException("startTime cannot be larger than endTime");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis((long)var2_3);
        int n2 = calendar2.get(1) - calendar.get(1);
        int n3 = calendar2.get(2) - calendar.get(2);
        return n2 * 12 + n3;
    }

    /*
     * WARNING - void declaration
     */
    private static Date innerGetEndOfThisPeriod(Calendar cal, PeriodicityType periodicityType, Date now) {
        void var2_2;
        void var1_1;
        return RollingCalendar.innerGetEndOfNextNthPeriod(cal, (PeriodicityType)var1_1, (Date)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static Date innerGetEndOfNextNthPeriod(Calendar cal, PeriodicityType periodicityType, Date now, int numPeriods) {
        Calendar calendar;
        void var1_1;
        void var2_2;
        cal.setTime((Date)var2_2);
        switch (1.$SwitchMap$ch$qos$logback$core$rolling$helper$PeriodicityType[var1_1.ordinal()]) {
            case 4: {
                cal.add(14, numPeriods);
                break;
            }
            case 5: {
                cal.set(14, 0);
                cal.add(13, numPeriods);
                break;
            }
            case 6: {
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(12, numPeriods);
                break;
            }
            case 1: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(11, numPeriods);
                break;
            }
            case 2: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(5, numPeriods);
                break;
            }
            case 3: {
                cal.set(7, cal.getFirstDayOfWeek());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(3, numPeriods);
                break;
            }
            case 8: {
                void var3_3;
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(2, (int)var3_3);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return calendar.getTime();
    }

    /*
     * WARNING - void declaration
     */
    public Date getEndOfNextNthPeriod(Date now, int periods) {
        void var2_2;
        void var1_1;
        RollingCalendar rollingCalendar = this;
        return RollingCalendar.innerGetEndOfNextNthPeriod(rollingCalendar, rollingCalendar.periodicityType, (Date)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Date getNextTriggeringDate(Date now) {
        void var1_1;
        return this.getEndOfNextNthPeriod((Date)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public long getStartOfCurrentPeriodWithGMTOffsetCorrection(long now, TimeZone timezone) {
        void var3_3;
        void var1_1;
        Calendar calendar = Calendar.getInstance(timezone);
        calendar.setTimeInMillis((long)var1_1);
        Date date = this.getEndOfNextNthPeriod(calendar.getTime(), 0);
        calendar = Calendar.getInstance((TimeZone)var3_3);
        calendar.setTimeInMillis(date.getTime());
        long l2 = calendar.get(15) + calendar.get(16);
        return date.getTime() + l2;
    }
}

