/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    /*
     * WARNING - void declaration
     */
    public FileNamePattern(String patternArg, Context contextArg) {
        void var2_2;
        void var1_1;
        this.setPattern(FileFilterUtil.slashify((String)var1_1));
        this.setContext((Context)var2_2);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            FileNamePattern fileNamePattern = this;
            Object object = fileNamePattern.escapeRightParantesis(fileNamePattern.pattern);
            object = new Parser((String)object, new AlmostAsIsEscapeUtil());
            ((ContextAwareBase)object).setContext(this.context);
            Node node = ((Parser)object).parse();
            this.headTokenConverter = ((Parser)object).compile(node, CONVERTER_MAP);
            return;
        }
        catch (ScanException scanException) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", scanException);
            return;
        }
    }

    String escapeRightParantesis(String in) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        int n2 = 31 + (this.pattern == null ? 0 : this.pattern.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        FileNamePattern fileNamePattern;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        fileNamePattern = fileNamePattern;
        return !(this.pattern == null ? fileNamePattern.pattern != null : !this.pattern.equals(fileNamePattern.pattern));
    }

    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            DateTokenConverter dateTokenConverter;
            if (!(converter instanceof DateTokenConverter) || !(dateTokenConverter = (DateTokenConverter)converter).isPrimary()) continue;
            return dateTokenConverter;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (!(converter instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)converter;
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter integerTokenConverter = this.getIntegerTokenConverter();
        return integerTokenConverter != null;
    }

    public String convert(Object o2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            stringBuilder.append(converter.convert(o2));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setPattern(String pattern) {
        if (pattern != null) {
            void var1_1;
            this.pattern = var1_1.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("\\d{1,2}");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            DateTokenConverter dateTokenConverter = (DateTokenConverter)converter;
            stringBuilder.append(dateTokenConverter.toRegex());
        }
        return stringBuilder.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }
}

