/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.DatePatternToRegexUtil;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DateTokenConverter<E>
extends DynamicConverter<E> {
    private String datePattern;
    private TimeZone timeZone;
    private CachingDateFormatter cdf;
    private boolean primary = true;

    @Override
    public void start() {
        List<String> list;
        this.datePattern = this.getFirstOption();
        if (this.datePattern == null) {
            this.datePattern = "yyyy-MM-dd";
        }
        if ((list = this.getOptionList()) != null) {
            for (int i2 = 1; i2 < list.size(); ++i2) {
                String string = list.get(i2);
                if ("AUX".equalsIgnoreCase(string)) {
                    this.primary = false;
                    continue;
                }
                this.timeZone = TimeZone.getTimeZone(string);
            }
        }
        this.cdf = new CachingDateFormatter(this.datePattern);
        if (this.timeZone != null) {
            this.cdf.setTimeZone(this.timeZone);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String convert(Date date) {
        void var1_1;
        return this.cdf.format(var1_1.getTime());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String convert(Object o2) {
        void var1_1;
        if (o2 == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o2 instanceof Date) {
            return this.convert((Date)o2);
        }
        throw new IllegalArgumentException("Cannot convert " + o2 + " of type" + var1_1.getClass().getName());
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toRegex() {
        DatePatternToRegexUtil datePatternToRegexUtil = new DatePatternToRegexUtil(this.datePattern);
        return datePatternToRegexUtil.toRegex();
    }

    public boolean isPrimary() {
        return this.primary;
    }
}

