/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;

    /*
     * WARNING - void declaration
     */
    public Compressor(CompressionMode compressionMode) {
        void var1_1;
        this.compressionMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(nameOfFile2Compress, nameOfCompressedFile);
                return;
            }
            case ZIP: {
                void var3_3;
                void var2_2;
                void var1_1;
                this.zipCompress((String)var1_1, (String)var2_2, (String)var3_3);
                return;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile, String innerEntryName) {
        Object object;
        File file = new File(nameOfFile2zip);
        if (!file.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (innerEntryName == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!nameOfZippedFile.endsWith(".zip")) {
            nameOfZippedFile = nameOfZippedFile + ".zip";
        }
        if (((File)(object = new File(nameOfZippedFile))).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfZippedFile + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + file + "] as [" + object + "]");
        this.createMissingTargetDirsIfNecessary((File)object);
        object = null;
        ZipOutputStream zipOutputStream = null;
        try {
            try {
                int n2;
                Object object2;
                object = new BufferedInputStream(new FileInputStream(nameOfFile2zip));
                zipOutputStream = new ZipOutputStream(new FileOutputStream(nameOfZippedFile));
                object2 = this.computeZipEntry((String)object2);
                zipOutputStream.putNextEntry((ZipEntry)object2);
                object2 = new byte[8192];
                while ((n2 = ((FilterInputStream)object).read((byte[])object2)) != -1) {
                    zipOutputStream.write((byte[])object2, 0, n2);
                }
                ((BufferedInputStream)object).close();
                object = null;
                zipOutputStream.close();
                zipOutputStream = null;
                if (!file.delete()) {
                    this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2zip + "].", this));
                }
                return;
            }
            catch (Exception exception) {
                void var2_3;
                void var1_1;
                this.addStatus(new ErrorStatus("Error occurred while compressing [" + (String)var1_1 + "] into [" + (String)var2_3 + "].", this, exception));
                if (object != null) {
                    try {
                        ((BufferedInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    ((BufferedInputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    ZipEntry computeZipEntry(String filename) {
        String string = Compressor.computeFileNameStrWithoutCompSuffix(filename, this.compressionMode);
        return new ZipEntry(string);
    }

    /*
     * WARNING - void declaration
     */
    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        Object object;
        File file = new File(nameOfFile2gz);
        if (!file.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!nameOfgzedFile.endsWith(".gz")) {
            nameOfgzedFile = nameOfgzedFile + ".gz";
        }
        if (((File)(object = new File(nameOfgzedFile))).exists()) {
            this.addWarn("The target compressed file named [" + nameOfgzedFile + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + file + "] as [" + object + "]");
        this.createMissingTargetDirsIfNecessary((File)object);
        object = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            try {
                int n2;
                object = new BufferedInputStream(new FileInputStream(nameOfFile2gz));
                deflaterOutputStream = new GZIPOutputStream(new FileOutputStream(nameOfgzedFile));
                byte[] byArray = new byte[8192];
                while ((n2 = ((FilterInputStream)object).read(byArray)) != -1) {
                    ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n2);
                }
                ((BufferedInputStream)object).close();
                object = null;
                deflaterOutputStream.close();
                deflaterOutputStream = null;
                if (!file.delete()) {
                    this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2gz + "].", this));
                }
                return;
            }
            catch (Exception exception) {
                void var2_3;
                void var1_1;
                this.addStatus(new ErrorStatus("Error occurred while compressing [" + (String)var1_1 + "] into [" + (String)var2_3 + "].", this, exception));
                if (object != null) {
                    try {
                        ((BufferedInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (deflaterOutputStream != null) {
                    try {
                        deflaterOutputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    ((BufferedInputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String computeFileNameStrWithoutCompSuffix(String fileNamePatternStr, CompressionMode compressionMode) {
        void var1_1;
        int n2 = fileNamePatternStr.length();
        switch (1.$SwitchMap$ch$qos$logback$core$rolling$helper$CompressionMode[var1_1.ordinal()]) {
            case 1: {
                if (fileNamePatternStr.endsWith(".gz")) {
                    return fileNamePatternStr.substring(0, n2 - 3);
                }
                return fileNamePatternStr;
            }
            case 2: {
                if (fileNamePatternStr.endsWith(".zip")) {
                    return fileNamePatternStr.substring(0, n2 - 4);
                }
                return fileNamePatternStr;
            }
            case 3: {
                String string;
                return string;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    /*
     * WARNING - void declaration
     */
    void createMissingTargetDirsIfNecessary(File file) {
        boolean bl = FileUtil.createMissingParentDirectories(file);
        if (!bl) {
            void var1_1;
            this.addError("Failed to create parent directories for [" + var1_1.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    public Future<?> asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        void var3_3;
        ScheduledExecutorService scheduledExecutorService;
        Object object;
        object = new CompressionRunnable((String)object, (String)((Object)scheduledExecutorService), (String)var3_3);
        scheduledExecutorService = this.context.getScheduledExecutorService();
        object = scheduledExecutorService.submit((Runnable)object);
        return object;
    }

    class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;

        /*
         * WARNING - void declaration
         */
        public CompressionRunnable(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
            void var3_3;
            void var2_2;
            this.nameOfFile2Compress = var2_2;
            this.nameOfCompressedFile = var3_3;
            this.innerEntryName = innerEntryName;
        }

        @Override
        public void run() {
            Compressor.this.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

