/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.recovery.RecoveryCoordinator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ResilientOutputStreamBase
extends OutputStream {
    private int noContextWarning = 0;
    private int statusCount = 0;
    private Context context;
    private RecoveryCoordinator recoveryCoordinator;
    protected OutputStream os;
    protected boolean presumedClean = true;

    private boolean isPresumedInError() {
        return this.recoveryCoordinator != null && !this.presumedClean;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b2, int off, int len) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.os.write((byte[])var1_1, (int)var2_3, (int)var3_4);
            this.postSuccessfulWrite();
            return;
        }
        catch (IOException iOException) {
            this.postIOFailure(iOException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b2) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            void var1_1;
            this.os.write((int)var1_1);
            this.postSuccessfulWrite();
            return;
        }
        catch (IOException iOException) {
            this.postIOFailure(iOException);
            return;
        }
    }

    @Override
    public void flush() {
        if (this.os != null) {
            try {
                this.os.flush();
                this.postSuccessfulWrite();
                return;
            }
            catch (IOException iOException) {
                this.postIOFailure(iOException);
            }
        }
    }

    abstract String getDescription();

    abstract OutputStream openNewOutputStream() throws IOException;

    private void postSuccessfulWrite() {
        if (this.recoveryCoordinator != null) {
            this.recoveryCoordinator = null;
            this.statusCount = 0;
            this.addStatus(new InfoStatus("Recovered from IO failure on " + this.getDescription(), this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postIOFailure(IOException e2) {
        void var1_1;
        this.addStatusIfCountNotOverLimit(new ErrorStatus("IO failure while writing to " + this.getDescription(), this, (Throwable)var1_1));
        this.presumedClean = false;
        if (this.recoveryCoordinator == null) {
            this.recoveryCoordinator = new RecoveryCoordinator();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
    }

    void attemptRecovery() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.addStatusIfCountNotOverLimit(new InfoStatus("Attempting to recover from IO failure on " + this.getDescription(), this));
        try {
            this.os = this.openNewOutputStream();
            this.presumedClean = true;
            return;
        }
        catch (IOException iOException) {
            this.addStatusIfCountNotOverLimit(new ErrorStatus("Failed to open " + this.getDescription(), this, iOException));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addStatusIfCountNotOverLimit(Status s2) {
        ++this.statusCount;
        if (this.statusCount < 8) {
            this.addStatus(s2);
        }
        if (this.statusCount == 8) {
            void var1_1;
            this.addStatus((Status)var1_1);
            this.addStatus(new InfoStatus("Will supress future messages regarding " + this.getDescription(), this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for " + this);
            }
            return;
        }
        StatusManager statusManager = this.context.getStatusManager();
        if (statusManager != null) {
            void var1_1;
            statusManager.add((Status)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(Context context) {
        void var1_1;
        this.context = var1_1;
    }
}

