/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    /*
     * WARNING - void declaration
     */
    TokenStream(String pattern, IEscapeUtil escapeUtil) {
        void var2_2;
        void var1_1;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = pattern;
        this.patternLength = var1_1.length();
        this.escapeUtil = var2_2;
    }

    List tokenize() throws ScanException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c2, arrayList, stringBuffer);
                    break;
                }
                case FORMAT_MODIFIER_STATE: {
                    this.handleFormatModifierState(c2, arrayList, stringBuffer);
                    break;
                }
                case OPTION_STATE: {
                    this.processOption(c2, arrayList, stringBuffer);
                    break;
                }
                case KEYWORD_STATE: {
                    this.handleKeywordState(c2, arrayList, stringBuffer);
                    break;
                }
                case RIGHT_PARENTHESIS_STATE: {
                    this.handleRightParenthesisState(c2, arrayList, stringBuffer);
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addValuedToken(1000, stringBuffer, arrayList);
                break;
            }
            case KEYWORD_STATE: {
                arrayList.add(new Token(1004, stringBuffer.toString()));
                break;
            }
            case RIGHT_PARENTHESIS_STATE: {
                arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case FORMAT_MODIFIER_STATE: 
            case OPTION_STATE: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void handleRightParenthesisState(char c2, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c2) {
            case ')': {
                return;
            }
            case '{': {
                this.state = TokenizerState.OPTION_STATE;
                return;
            }
            case '\\': {
                this.escape("%{}", buf);
                this.state = TokenizerState.LITERAL_STATE;
                return;
            }
        }
        var3_3.append((char)var1_1);
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    private void processOption(char c2, List<Token> tokenList, StringBuffer buf) throws ScanException {
        void var2_2;
        void var1_1;
        OptionTokenizer optionTokenizer = new OptionTokenizer(this);
        optionTokenizer.tokenize((char)var1_1, (List<Token>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void handleFormatModifierState(char c2, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        if (c2 == '(') {
            this.addValuedToken(1002, buf, tokenList);
            tokenList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenizerState.LITERAL_STATE;
            return;
        }
        if (Character.isJavaIdentifierStart(c2)) {
            void var2_2;
            this.addValuedToken(1002, buf, (List<Token>)var2_2);
            this.state = TokenizerState.KEYWORD_STATE;
            buf.append(c2);
            return;
        }
        var3_3.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void handleLiteralState(char c2, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        switch (c2) {
            case '\\': {
                this.escape("%()", buf);
                return;
            }
            case '%': {
                this.addValuedToken(1000, buf, tokenList);
                tokenList.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            case ')': {
                void var2_2;
                this.addValuedToken(1000, buf, (List<Token>)var2_2);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
        }
        var3_3.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void handleKeywordState(char c2, List<Token> tokenList, StringBuffer buf) {
        if (Character.isJavaIdentifierPart(c2)) {
            buf.append(c2);
            return;
        }
        if (c2 == '{') {
            this.addValuedToken(1004, buf, tokenList);
            this.state = TokenizerState.OPTION_STATE;
            return;
        }
        if (c2 == '(') {
            this.addValuedToken(1005, buf, tokenList);
        } else {
            char c3;
            void var2_2;
            if (c2 == '%') {
                this.addValuedToken(1004, buf, tokenList);
                tokenList.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            if (c2 == ')') {
                this.addValuedToken(1004, buf, tokenList);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
            this.addValuedToken(1004, buf, (List<Token>)var2_2);
            if (c2 == '\\') {
                if (this.pointer < this.patternLength) {
                    c3 = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", buf, c3, this.pointer);
                }
            } else {
                void var3_3;
                var3_3.append(c3);
            }
        }
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    void escape(String escapeChars, StringBuffer buf) {
        if (this.pointer < this.patternLength) {
            void var2_2;
            void var1_1;
            char c2 = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape((String)var1_1, (StringBuffer)var2_2, c2, this.pointer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addValuedToken(int type, StringBuffer buf, List<Token> tokenList) {
        if (buf.length() > 0) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.add(new Token((int)var1_1, buf.toString()));
            var2_2.setLength(0);
        }
    }

    static final class TokenizerState
    extends Enum<TokenizerState> {
        public static final /* enum */ TokenizerState LITERAL_STATE = new TokenizerState();
        public static final /* enum */ TokenizerState FORMAT_MODIFIER_STATE = new TokenizerState();
        public static final /* enum */ TokenizerState KEYWORD_STATE = new TokenizerState();
        public static final /* enum */ TokenizerState OPTION_STATE = new TokenizerState();
        public static final /* enum */ TokenizerState RIGHT_PARENTHESIS_STATE = new TokenizerState();
        private static final /* synthetic */ TokenizerState[] $VALUES;

        public static TokenizerState[] values() {
            return (TokenizerState[])$VALUES.clone();
        }

        static {
            $VALUES = new TokenizerState[]{LITERAL_STATE, FORMAT_MODIFIER_STATE, KEYWORD_STATE, OPTION_STATE, RIGHT_PARENTHESIS_STATE};
        }
    }
}

