/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.AsIsEscapeUtil;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

public class OptionTokenizer {
    final IEscapeUtil escapeUtil;
    final TokenStream tokenStream;
    final String pattern;
    final int patternLength;
    char quoteChar;
    int state = 0;

    /*
     * WARNING - void declaration
     */
    OptionTokenizer(TokenStream tokenStream) {
        this((TokenStream)var1_1, new AsIsEscapeUtil());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    OptionTokenizer(TokenStream tokenStream, IEscapeUtil escapeUtil) {
        void var2_2;
        void var1_1;
        this.tokenStream = tokenStream;
        this.pattern = tokenStream.pattern;
        this.patternLength = var1_1.patternLength;
        this.escapeUtil = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void tokenize(char firstChar, List<Token> tokenList) throws ScanException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.tokenStream.pointer < this.patternLength) {
            block0 : switch (this.state) {
                case 0: {
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ',': {
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = c2;
                            break block0;
                        }
                        case '}': {
                            this.emitOptionToken(tokenList, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c2);
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c2) {
                        case ',': {
                            arrayList.add(stringBuffer.toString().trim());
                            stringBuffer.setLength(0);
                            this.state = 0;
                            break block0;
                        }
                        case '}': {
                            arrayList.add(stringBuffer.toString().trim());
                            this.emitOptionToken(tokenList, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 2: {
                    if (c2 == this.quoteChar) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        this.state = 0;
                        break;
                    }
                    if (c2 == '\\') {
                        OptionTokenizer optionTokenizer = this;
                        optionTokenizer.escape(String.valueOf(optionTokenizer.quoteChar), stringBuffer);
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
            c2 = this.pattern.charAt(this.tokenStream.pointer);
            ++this.tokenStream.pointer;
        }
        if (c2 == '}') {
            if (this.state == 0) {
                this.emitOptionToken(tokenList, arrayList);
                return;
            }
            if (this.state == 1) {
                void var2_2;
                arrayList.add(stringBuffer.toString().trim());
                this.emitOptionToken((List<Token>)var2_2, arrayList);
                return;
            }
            throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
        }
        throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
    }

    /*
     * WARNING - void declaration
     */
    void emitOptionToken(List<Token> tokenList, List<String> optionList) {
        void var2_2;
        tokenList.add(new Token(1006, var2_2));
        this.tokenStream.state = TokenStream.TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    void escape(String escapeChars, StringBuffer buf) {
        if (this.tokenStream.pointer < this.patternLength) {
            void var2_2;
            void var1_1;
            char c2 = this.pattern.charAt(this.tokenStream.pointer++);
            this.escapeUtil.escape((String)var1_1, (StringBuffer)var2_2, c2, this.tokenStream.pointer);
        }
    }
}

