/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map converterMap;

    /*
     * WARNING - void declaration
     */
    Compiler(Node top, Map converterMap) {
        void var2_2;
        void var1_1;
        this.top = var1_1;
        this.converterMap = var2_2;
    }

    Converter<E> compile() {
        Compiler compiler = this;
        compiler.tail = null;
        compiler.head = null;
        Node node = this.top;
        while (node != null) {
            switch (node.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)node.getValue()));
                    break;
                }
                case 2: {
                    Converter<E> converter = (CompositeNode)node;
                    Converter converter2 = this.createCompositeConverter((CompositeNode)((Object)converter));
                    if (converter2 == null) {
                        this.addError("Failed to create converter for [%" + ((Node)((Object)converter)).getValue() + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + ((Node)((Object)converter)).getValue() + "]"));
                        break;
                    }
                    ((FormattingConverter)converter2).setFormattingInfo(((FormattingNode)((Object)converter)).getFormatInfo());
                    ((DynamicConverter)converter2).setOptionList(((SimpleKeywordNode)((Object)converter)).getOptions());
                    converter = new Compiler<E>(((CompositeNode)((Object)converter)).getChildNode(), this.converterMap);
                    ((ContextAwareBase)((Object)converter)).setContext(this.context);
                    converter = ((Compiler)((Object)converter)).compile();
                    ((CompositeConverter)converter2).setChildConverter(converter);
                    this.addToList(converter2);
                    break;
                }
                case 1: {
                    Converter<E> converter = (SimpleKeywordNode)node;
                    Converter converter2 = this.createConverter((SimpleKeywordNode)((Object)converter));
                    if (converter2 != null) {
                        ((FormattingConverter)converter2).setFormattingInfo(((FormattingNode)((Object)converter)).getFormatInfo());
                        ((DynamicConverter)converter2).setOptionList(((SimpleKeywordNode)((Object)converter)).getOptions());
                        this.addToList(converter2);
                        break;
                    }
                    converter2 = new LiteralConverter("%PARSER_ERROR[" + ((Node)((Object)converter)).getValue() + "]");
                    this.addStatus(new ErrorStatus("[" + ((Node)((Object)converter)).getValue() + "] is not a valid conversion word", this));
                    this.addToList(converter2);
                }
            }
            node = node.next;
        }
        return this.head;
    }

    /*
     * WARNING - void declaration
     */
    private void addToList(Converter<E> c2) {
        void var1_1;
        if (this.head == null) {
            this.tail = c2;
            this.head = this.tail;
            return;
        }
        this.tail.setNext(c2);
        this.tail = var1_1;
    }

    DynamicConverter<E> createConverter(SimpleKeywordNode kn) {
        String string = (String)kn.getValue();
        String string2 = (String)this.converterMap.get(string);
        if (string2 != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(string2, DynamicConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string2 + "] for keyword [" + string + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for conversion word [" + string + "]");
        return null;
    }

    CompositeConverter<E> createCompositeConverter(CompositeNode cn) {
        String string = (String)cn.getValue();
        String string2 = (String)this.converterMap.get(string);
        if (string2 != null) {
            try {
                return (CompositeConverter)OptionHelper.instantiateByClassName(string2, CompositeConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string2 + "] as a composite converter for keyword [" + string + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + string + "]");
        return null;
    }
}

