/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;

public abstract class PatternLayoutBase<E>
extends LayoutBase<E> {
    Converter<E> head;
    String pattern;
    protected PostCompileProcessor<E> postCompileProcessor;
    Map<String, String> instanceConverterMap = new HashMap<String, String>();
    protected boolean outputPatternAsHeader = false;

    public abstract Map<String, String> getDefaultConverterMap();

    public Map<String, String> getEffectiveConverterMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = this.getDefaultConverterMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        if ((map = this.getContext()) != null && (map = (Map)map.getObject("PATTERN_RULE_REGISTRY")) != null) {
            hashMap.putAll(map);
        }
        hashMap.putAll(this.instanceConverterMap);
        return hashMap;
    }

    @Override
    public void start() {
        if (this.pattern == null || this.pattern.length() == 0) {
            this.addError("Empty or null pattern.");
            return;
        }
        try {
            Parser parser = new Parser(this.pattern);
            if (this.getContext() != null) {
                parser.setContext(this.getContext());
            }
            Node node = parser.parse();
            this.head = parser.compile(node, this.getEffectiveConverterMap());
            if (this.postCompileProcessor != null) {
                this.postCompileProcessor.process(this.context, this.head);
            }
            ConverterUtil.setContextForConverters(this.getContext(), this.head);
            ConverterUtil.startConverters(this.head);
            super.start();
            return;
        }
        catch (ScanException scanException) {
            StatusManager statusManager = this.getContext().getStatusManager();
            statusManager.add(new ErrorStatus("Failed to parse pattern \"" + this.getPattern() + "\".", this, scanException));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPostCompileProcessor(PostCompileProcessor<E> postCompileProcessor) {
        void var1_1;
        this.postCompileProcessor = var1_1;
    }

    protected String writeLoopOnConverters(E event) {
        StringBuilder stringBuilder = new StringBuilder(256);
        for (Converter<E> converter = this.head; converter != null; converter = converter.getNext()) {
            converter.write(stringBuilder, event);
        }
        return stringBuilder.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    public void setPattern(String pattern) {
        void var1_1;
        this.pattern = var1_1;
    }

    public String toString() {
        return this.getClass().getName() + "(\"" + this.getPattern() + "\")";
    }

    protected String getPresentationHeaderPrefix() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputPatternAsHeader(boolean outputPatternAsHeader) {
        void var1_1;
        this.outputPatternAsHeader = var1_1;
    }

    @Override
    public String getPresentationHeader() {
        if (this.outputPatternAsHeader) {
            return this.getPresentationHeaderPrefix() + this.pattern;
        }
        return super.getPresentationHeader();
    }
}

