/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

public class ThrowableToStringArray {
    public static String[] convert(Throwable t2) {
        Throwable throwable;
        LinkedList<String> linkedList = new LinkedList<String>();
        ThrowableToStringArray.extract(linkedList, throwable, null);
        return linkedList.toArray(new String[0]);
    }

    private static void extract(List<String> strList, Throwable t2, StackTraceElement[] parentSTE) {
        while (true) {
            StackTraceElement[] stackTraceElementArray;
            StackTraceElement[] stackTraceElementArray2 = t2.getStackTrace();
            int n2 = ThrowableToStringArray.findNumberOfCommonFrames(stackTraceElementArray2, parentSTE);
            strList.add(ThrowableToStringArray.formatFirstLine((Throwable)t2, parentSTE));
            for (int i2 = 0; i2 < stackTraceElementArray2.length - n2; ++i2) {
                strList.add("\tat " + stackTraceElementArray2[i2].toString());
            }
            if (n2 != 0) {
                strList.add("\t... " + n2 + " common frames omitted");
            }
            if ((stackTraceElementArray = t2.getCause()) == null) break;
            StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray;
            stackTraceElementArray = stackTraceElementArray2;
            t2 = stackTraceElementArray3;
        }
    }

    private static String formatFirstLine(Throwable t2, StackTraceElement[] parentSTE) {
        String string;
        String string2 = "";
        if (string != null) {
            string2 = "Caused by: ";
        }
        string = string2 + t2.getClass().getName();
        if (t2.getMessage() != null) {
            Throwable throwable;
            string = string + ": " + throwable.getMessage();
        }
        return string;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] ste, StackTraceElement[] parentSTE) {
        if (parentSTE == null) {
            return 0;
        }
        int n2 = ste.length - 1;
        int n3 = 0;
        for (int i2 = parentSTE.length - 1; n2 >= 0 && i2 >= 0 && ste[n2].equals(parentSTE[i2]); --n2, --i2) {
            ++n3;
        }
        return n3;
    }
}

