/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.ArrayList;
import java.util.List;

public class CyclicBuffer<E> {
    E[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    /*
     * WARNING - void declaration
     */
    public CyclicBuffer(int maxSize) throws IllegalArgumentException {
        void var1_1;
        if (maxSize <= 0) {
            throw new IllegalArgumentException("The maxSize argument (" + maxSize + ") is not a positive integer.");
        }
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void init(int maxSize) {
        void var1_1;
        this.maxSize = maxSize;
        this.ea = new Object[var1_1];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void add(E event) {
        void var1_1;
        this.ea[this.last] = var1_1;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
            return;
        }
        if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public E get(int i2) {
        void var1_1;
        if (i2 < 0 || i2 >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + var1_1) % this.maxSize];
    }

    public List<E> asList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i2 = 0; i2 < this.length(); ++i2) {
            arrayList.add(this.get(i2));
        }
        return arrayList;
    }

    public int length() {
        return this.numElems;
    }
}

