/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;

public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    Appender<?> parent;
    Boolean immediateFlush = null;

    public Layout<E> getLayout() {
        return this.layout;
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(Layout<E> layout) {
        void var1_1;
        this.layout = var1_1;
    }

    @Override
    public byte[] headerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getFileHeader());
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationHeader());
        if (stringBuilder.length() > 0) {
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        return this.convertToBytes(stringBuilder.toString());
    }

    @Override
    public byte[] footerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationFooter());
        this.appendIfNotNull(stringBuilder, this.layout.getFileFooter());
        return this.convertToBytes(stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private byte[] convertToBytes(String s2) {
        void var1_1;
        if (this.charset == null) {
            return s2.getBytes();
        }
        return var1_1.getBytes(this.charset);
    }

    @Override
    public byte[] encode(E event) {
        String string;
        string = this.layout.doLayout((void)string);
        return this.convertToBytes(string);
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void start() {
        if (this.immediateFlush != null) {
            if (this.parent instanceof OutputStreamAppender) {
                this.addWarn("Setting the \"immediateFlush\" property of the enclosing appender to " + this.immediateFlush);
                OutputStreamAppender outputStreamAppender = (OutputStreamAppender)this.parent;
                outputStreamAppender.setImmediateFlush(this.immediateFlush);
            } else {
                this.addError("Could not set the \"immediateFlush\" property of the enclosing appender.");
            }
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    /*
     * WARNING - void declaration
     */
    private void appendIfNotNull(StringBuilder sb, String s2) {
        if (s2 != null) {
            void var2_2;
            void var1_1;
            var1_1.append((String)var2_2);
        }
    }
}

