/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public class OutputStreamAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected Encoder<E> encoder;
    protected final ReentrantLock lock = new ReentrantLock(false);
    private OutputStream outputStream;
    boolean immediateFlush = true;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", this));
            ++n2;
        }
        if (this.outputStream == null) {
            this.addStatus(new ErrorStatus("No output stream set for the appender named \"" + this.name + "\".", this));
            ++n2;
        }
        if (n2 == 0) {
            super.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(Layout<E> layout) {
        void var1_1;
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder layoutWrappingEncoder = new LayoutWrappingEncoder();
        layoutWrappingEncoder.setLayout(var1_1);
        layoutWrappingEncoder.setContext(this.context);
        this.encoder = layoutWrappingEncoder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E eventObject) {
        void var1_1;
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(var1_1);
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.closeOutputStream();
            super.stop();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.encoderClose();
                this.outputStream.close();
                this.outputStream = null;
                return;
            }
            catch (IOException iOException) {
                this.addStatus(new ErrorStatus("Could not close output stream for OutputStreamAppender.", this, iOException));
            }
        }
    }

    void encoderClose() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.footerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputStream(OutputStream outputStream) {
        this.lock.lock();
        try {
            void var1_1;
            this.closeOutputStream();
            this.outputStream = var1_1;
            if (this.encoder == null) {
                this.addWarn("Encoder has not been set. Cannot invoke its init method.");
                return;
            }
            this.encoderInit();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    void encoderInit() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.headerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    protected void writeOut(E event) throws IOException {
        byte[] byArray;
        byArray = this.encoder.encode((void)byArray);
        this.writeBytes(byArray);
    }

    /*
     * WARNING - void declaration
     */
    private void writeBytes(byte[] byteArray) throws IOException {
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        this.lock.lock();
        try {
            void var1_1;
            this.outputStream.write((byte[])var1_1);
            if (this.immediateFlush) {
                this.outputStream.flush();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void subAppend(E event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            byte[] byArray;
            if (event instanceof DeferredProcessingAware) {
                ((DeferredProcessingAware)event).prepareForDeferredProcessing();
            }
            byArray = this.encoder.encode((void)byArray);
            this.writeBytes(byArray);
            return;
        }
        catch (IOException iOException) {
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, iOException));
            return;
        }
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoder(Encoder<E> encoder) {
        void var1_1;
        this.encoder = var1_1;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    /*
     * WARNING - void declaration
     */
    public void setImmediateFlush(boolean immediateFlush) {
        void var1_1;
        this.immediateFlush = var1_1;
    }
}

