/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.recovery.ResilientOutputStreamBase;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    public static final long DEFAULT_BUFFER_SIZE = 8192L;
    protected static String COLLISION_WITH_EARLIER_APPENDER_URL = "http://logback.qos.ch/codes.html#earlier_fa_collision";
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private FileSize bufferSize = new FileSize(8192L);

    /*
     * WARNING - void declaration
     */
    public void setFile(String file) {
        void var1_1;
        if (file == null) {
            this.fileName = file;
            return;
        }
        this.fileName = var1_1.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (this.checkForFileCollisionInPreviousFileAppenders()) {
                this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
                ++n2;
            } else {
                try {
                    FileAppender fileAppender = this;
                    fileAppender.openFile(fileAppender.getFile());
                }
                catch (IOException iOException) {
                    ++n2;
                    this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", iOException);
                }
            }
        } else {
            ++n2;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (n2 == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        Map<String, String> map = ContextUtil.getFilenameCollisionMap(this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        map.remove(this.getName());
    }

    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        boolean bl = false;
        if (this.fileName == null) {
            return false;
        }
        Map map = (Map)this.context.getObject("FA_FILENAME_COLLISION_MAP");
        if (map == null) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            bl = true;
        }
        if (this.name != null) {
            map.put(this.getName(), this.fileName);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void addErrorForCollision(String optionName, String optionValue, String appenderName) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addError("'" + (String)var1_1 + "' option has the same value \"" + (String)var2_2 + "\" as that given for appender [" + (String)var3_3 + "] defined earlier.");
    }

    public void openFile(String file_name) throws IOException {
        this.lock.lock();
        try {
            Object object;
            object = new File((String)object);
            boolean bl = FileUtil.createMissingParentDirectories((File)object);
            if (!bl) {
                this.addError("Failed to create parent directories for [" + ((File)object).getAbsolutePath() + "]");
            }
            object = new ResilientFileOutputStream((File)object, this.append, this.bufferSize.getSize());
            ((ResilientOutputStreamBase)object).setContext(this.context);
            this.setOutputStream((OutputStream)object);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrudent(boolean prudent) {
        void var1_1;
        this.prudent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAppend(boolean append) {
        void var1_1;
        this.append = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBufferSize(FileSize bufferSize) {
        void var1_1;
        this.addInfo("Setting bufferSize to [" + bufferSize.toString() + "]");
        this.bufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void safeWrite(E event) throws IOException {
        block10: {
            boolean bl;
            block9: {
                ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.getOutputStream();
                FileChannel fileChannel = resilientFileOutputStream.getChannel();
                if (fileChannel == null) {
                    return;
                }
                bl = Thread.interrupted();
                FileLock fileLock = null;
                try {
                    void var1_1;
                    fileLock = fileChannel.lock();
                    long l2 = fileChannel.position();
                    long l3 = fileChannel.size();
                    if (l3 != l2) {
                        fileChannel.position(l3);
                    }
                    super.writeOut(var1_1);
                    if (fileLock == null || !fileLock.isValid()) break block9;
                }
                catch (IOException iOException) {
                    resilientFileOutputStream.postIOFailure(iOException);
                    return;
                }
                finally {
                    if (fileLock != null && fileLock.isValid()) {
                        fileLock.release();
                    }
                    if (!bl) break block10;
                    Thread.currentThread().interrupt();
                }
                fileLock.release();
            }
            if (bl) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeOut(E event) throws IOException {
        void var1_1;
        if (this.prudent) {
            this.safeWrite(event);
            return;
        }
        super.writeOut(var1_1);
    }
}

