/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

public class ContextBase
implements Context,
LifeCycle {
    private long birthTime = System.currentTimeMillis();
    private String name;
    private StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    LogbackLock configurationLock = new LogbackLock();
    private ScheduledExecutorService scheduledExecutorService;
    protected List<ScheduledFuture<?>> scheduledFutures = new ArrayList(1);
    private LifeCycleManager lifeCycleManager;
    private boolean started;

    public ContextBase() {
        this.initCollisionMaps();
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    protected void initCollisionMaps() {
        this.putObject("FA_FILENAME_COLLISION_MAP", new HashMap());
        this.putObject("RFA_FILENAME_PATTERN_COLLISION_MAP", new HashMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObject(String key) {
        void var1_1;
        return this.objectMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void putObject(String key, Object value) {
        void var2_2;
        void var1_1;
        this.objectMap.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(String key) {
        void var1_1;
        this.objectMap.remove(var1_1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.stopExecutorService();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void reset() {
        this.removeShutdownHook();
        this.getLifeCycleManager().reset();
        this.propertyMap.clear();
        this.objectMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) throws IllegalStateException {
        if (name != null && name.equals(this.name)) {
            return;
        }
        if (this.name == null || "default".equals(this.name)) {
            void var1_1;
            this.name = var1_1;
            return;
        }
        throw new IllegalStateException("Context has been already given a name");
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = ExecutorServiceUtil.newScheduledExecutorService();
        }
        return this.scheduledExecutorService;
    }

    private synchronized void stopExecutorService() {
        if (this.scheduledExecutorService != null) {
            ExecutorServiceUtil.shutdown(this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
    }

    private void removeShutdownHook() {
        Thread thread = (Thread)this.getObject("SHUTDOWN_HOOK");
        if (thread != null) {
            this.removeObject("SHUTDOWN_HOOK");
            try {
                Runtime.getRuntime().removeShutdownHook(thread);
                return;
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    synchronized LifeCycleManager getLifeCycleManager() {
        if (this.lifeCycleManager == null) {
            this.lifeCycleManager = new LifeCycleManager();
        }
        return this.lifeCycleManager;
    }

    public String toString() {
        return this.name;
    }
}

