/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ThrowableProxy
implements IThrowableProxy {
    private Throwable throwable;
    private String className;
    private String message;
    StackTraceElementProxy[] stackTraceElementProxyArray;
    int commonFrames;
    private ThrowableProxy cause;
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;
    private static final Method GET_SUPPRESSED_METHOD;
    private static final ThrowableProxy[] NO_SUPPRESSED;

    public ThrowableProxy(Throwable throwable) {
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(throwable.getStackTrace());
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            this.cause = new ThrowableProxy(throwable2);
            this.cause.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwable2.getStackTrace(), this.stackTraceElementProxyArray);
        }
        if (GET_SUPPRESSED_METHOD != null) {
            try {
                Throwable[] throwableArray;
                throwableArray = GET_SUPPRESSED_METHOD.invoke((Object)throwableArray, new Object[0]);
                if (throwableArray instanceof Throwable[] && (throwableArray = (Throwable[])throwableArray).length > 0) {
                    this.suppressed = new ThrowableProxy[throwableArray.length];
                    for (int i2 = 0; i2 < throwableArray.length; ++i2) {
                        this.suppressed[i2] = new ThrowableProxy(throwableArray[i2]);
                        this.suppressed[i2].commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwableArray[i2].getStackTrace(), this.stackTraceElementProxyArray);
                    }
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    @Override
    public int getCommonFrames() {
        return this.commonFrames;
    }

    @Override
    public IThrowableProxy getCause() {
        return this.cause;
    }

    @Override
    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator packagingDataCalculator = this.getPackagingDataCalculator();
        if (packagingDataCalculator != null) {
            this.calculatedPackageData = true;
            packagingDataCalculator.calculate(this);
        }
    }

    static {
        Method method = null;
        try {
            method = Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        GET_SUPPRESSED_METHOD = method;
        NO_SUPPRESSED = new ThrowableProxy[0];
    }
}

