/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import sun.reflect.Reflection;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;

    public void calculate(IThrowableProxy tp) {
        while (tp != null) {
            this.populateFrames(tp.getStackTraceElementProxyArray());
            IThrowableProxy[] iThrowableProxyArray = tp.getSuppressed();
            if (iThrowableProxyArray != null) {
                for (IThrowableProxy iThrowableProxy : iThrowableProxyArray) {
                    this.populateFrames(iThrowableProxy.getStackTraceElementProxyArray());
                }
            }
            tp = tp.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    void populateFrames(StackTraceElementProxy[] stepArray) {
        void var1_1;
        StackTraceElement[] stackTraceElementArray = new Throwable("local stack reference");
        stackTraceElementArray = stackTraceElementArray.getStackTrace();
        int n2 = STEUtil.findNumberOfCommonFrames(stackTraceElementArray, stepArray);
        int n3 = stackTraceElementArray.length - n2;
        int n4 = stepArray.length - n2;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = null;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable = null;
            if (GET_CALLER_CLASS_METHOD_AVAILABLE) {
                serializable = Reflection.getCallerClass((int)(n3 + i2 - n5 + 1));
            }
            StackTraceElementProxy stackTraceElementProxy = stepArray[n4 + i2];
            String string = stackTraceElementProxy.ste.getClassName();
            if (serializable != null && string.equals(serializable.getName())) {
                classLoader = serializable.getClassLoader();
                if (classLoader2 == null) {
                    classLoader2 = classLoader;
                }
                serializable = this.calculateByExactType((Class)serializable);
                stackTraceElementProxy.setClassPackagingData((ClassPackagingData)serializable);
                continue;
            }
            ++n5;
            serializable = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData((ClassPackagingData)serializable);
        }
        this.populateUncommonFrames(n2, (StackTraceElementProxy[])var1_1, classLoader2);
    }

    void populateUncommonFrames(int commonFrames, StackTraceElementProxy[] stepArray, ClassLoader firstExactClassLoader) {
        int n2;
        n2 = stepArray.length - n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stepArray[i2];
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, firstExactClassLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
    }

    private ClassPackagingData calculateByExactType(Class type) {
        String string;
        String string2 = type.getName();
        Object object = this.cache.get(string2);
        if (object != null) {
            return object;
        }
        object = this.getImplementationVersion(type);
        string = this.getCodeLocation((Class)((Object)string));
        object = new ClassPackagingData(string, (String)object);
        this.cache.put(string2, (ClassPackagingData)object);
        return object;
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy step, ClassLoader lastExactClassLoader) {
        Object object;
        String string = step.ste.getClassName();
        Object object2 = this.cache.get(string);
        if (object2 != null) {
            return object2;
        }
        object = this.bestEffortLoadClass((ClassLoader)object, string);
        object2 = this.getImplementationVersion((Class)object);
        object = this.getCodeLocation((Class)object);
        object2 = new ClassPackagingData((String)object, (String)object2, false);
        this.cache.put(string, (ClassPackagingData)object2);
        return object2;
    }

    String getImplementationVersion(Class type) {
        Object object;
        if (type == null) {
            return "na";
        }
        if ((object = ((Class)object).getPackage()) != null) {
            if ((object = ((Package)object).getImplementationVersion()) == null) {
                return "na";
            }
            return object;
        }
        return "na";
    }

    String getCodeLocation(Class type) {
        try {
            Object object;
            if (type != null && (object = ((Class)object).getProtectionDomain().getCodeSource()) != null && (object = ((CodeSource)object).getLocation()) != null) {
                String string = this.getCodeLocation((String)(object = ((URL)object).toString()), '/');
                if (string != null) {
                    return string;
                }
                return this.getCodeLocation((String)object, '\\');
            }
        }
        catch (Exception exception) {}
        return "na";
    }

    /*
     * WARNING - void declaration
     */
    private String getCodeLocation(String locationStr, char separator) {
        int n2 = locationStr.lastIndexOf(separator);
        if (this.isFolder(n2, locationStr)) {
            void var2_2;
            n2 = locationStr.lastIndexOf((int)var2_2, n2 - 1);
            return locationStr.substring(n2 + 1);
        }
        if (n2 > 0) {
            void var1_1;
            return var1_1.substring(n2 + 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFolder(int idx, String text) {
        void var2_2;
        void var1_1;
        return idx != -1 && var1_1 + true == var2_2.length();
    }

    /*
     * WARNING - void declaration
     */
    private Class loadClass(ClassLoader cl, String className) {
        Exception exception;
        if (cl == null) {
            return null;
        }
        try {
            void var2_2;
            return ((ClassLoader)((Object)exception)).loadClass((String)var2_2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class bestEffortLoadClass(ClassLoader lastGuaranteedClassLoader, String className) {
        Exception exception;
        Class clazz = this.loadClass(lastGuaranteedClassLoader, className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != exception) {
            clazz = this.loadClass(classLoader, className);
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            void var2_2;
            return Class.forName((String)var2_2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Reflection.getCallerClass((int)2);
            GET_CALLER_CLASS_METHOD_AVAILABLE = true;
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Unexpected exception");
            throwable.printStackTrace();
            return;
        }
    }
}

