/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.EventArgUtil;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import java.util.Collections;
import java.util.Map;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.MDCAdapter;

public class LoggingEvent
implements ILoggingEvent {
    transient String fqnOfLoggerClass;
    private String threadName;
    private String loggerName;
    private LoggerContext loggerContext;
    private LoggerContextVO loggerContextVO;
    private transient Level level;
    private String message;
    transient String formattedMessage;
    private transient Object[] argumentArray;
    private ThrowableProxy throwableProxy;
    private StackTraceElement[] callerDataArray;
    private Marker marker;
    private Map<String, String> mdcPropertyMap;
    private long timeStamp;

    public LoggingEvent() {
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray) {
        void var3_3;
        LoggerContext loggerContext;
        this.fqnOfLoggerClass = loggerContext;
        this.loggerName = logger.getName();
        this.loggerContext = logger.getLoggerContext();
        this.loggerContextVO = this.loggerContext.getLoggerContextRemoteView();
        this.level = var3_3;
        this.message = message;
        this.argumentArray = argArray;
        if (throwable == null) {
            throwable = this.extractThrowableAnRearrangeArguments(argArray);
        }
        if (throwable != null) {
            void var2_2;
            this.throwableProxy = new ThrowableProxy(throwable);
            loggerContext = var2_2.getLoggerContext();
            if (loggerContext.isPackagingDataEnabled()) {
                this.throwableProxy.calculatePackagingData();
            }
        }
        this.timeStamp = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    private Throwable extractThrowableAnRearrangeArguments(Object[] argArray) {
        Throwable throwable = EventArgUtil.extractThrowable(argArray);
        if (EventArgUtil.successfulExtraction(throwable)) {
            void var1_1;
            this.argumentArray = EventArgUtil.trimmedCopy((Object[])var1_1);
        }
        return throwable;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    @Override
    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    @Override
    public void prepareForDeferredProcessing() {
        this.getFormattedMessage();
        this.getThreadName();
        this.getMDCPropertyMap();
    }

    @Override
    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public StackTraceElement[] getCallerData() {
        if (this.callerDataArray == null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass, this.loggerContext.getMaxCallerDataDepth(), this.loggerContext.getFrameworkPackages());
        }
        return this.callerDataArray;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    /*
     * WARNING - void declaration
     */
    public void setMarker(Marker marker) {
        void var1_1;
        if (this.marker != null) {
            throw new IllegalStateException("The marker has been already set for this event.");
        }
        this.marker = var1_1;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat(this.message, this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    @Override
    public Map<String, String> getMDCPropertyMap() {
        if (this.mdcPropertyMap == null) {
            MDCAdapter mDCAdapter = MDC.getMDCAdapter();
            this.mdcPropertyMap = mDCAdapter instanceof LogbackMDCAdapter ? ((LogbackMDCAdapter)mDCAdapter).getPropertyMap() : mDCAdapter.getCopyOfContextMap();
        }
        if (this.mdcPropertyMap == null) {
            this.mdcPropertyMap = Collections.emptyMap();
        }
        return this.mdcPropertyMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.level).append("] ");
        stringBuilder.append(this.getFormattedMessage());
        return stringBuilder.toString();
    }
}

