/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.JNDIUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;

public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    /*
     * WARNING - void declaration
     */
    public ContextJNDISelector(LoggerContext context) {
        void var1_1;
        this.defaultContext = var1_1;
    }

    @Override
    public LoggerContext getLoggerContext() {
        Object object = null;
        javax.naming.Context context = null;
        LoggerContext loggerContext = threadLocal.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        try {
            context = JNDIUtil.getInitialContext();
            object = JNDIUtil.lookup(context, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (object == null) {
            return this.defaultContext;
        }
        loggerContext = this.synchronizedContextMap.get(object);
        if (loggerContext == null) {
            loggerContext = new LoggerContext();
            loggerContext.setName((String)object);
            this.synchronizedContextMap.put((String)object, loggerContext);
            object = this.findConfigFileURL(context, loggerContext);
            if (object != null) {
                this.configureLoggerContextByURL(loggerContext, (URL)object);
            } else {
                try {
                    new ContextInitializer(loggerContext);
                }
                catch (JoranException joranException) {}
            }
            if (!StatusUtil.contextHasStatusListener(loggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
            }
        }
        return loggerContext;
    }

    /*
     * WARNING - void declaration
     */
    private String conventionalConfigFileName(String contextName) {
        void var1_1;
        return "logback-" + (String)var1_1 + ".xml";
    }

    /*
     * WARNING - void declaration
     */
    private URL findConfigFileURL(javax.naming.Context ctx, LoggerContext loggerContext) {
        void var2_2;
        String string;
        StatusManager statusManager = loggerContext.getStatusManager();
        if ((string = JNDIUtil.lookup((javax.naming.Context)((Object)string), "java:comp/env/logback/configuration-resource")) != null) {
            statusManager.add(new InfoStatus("Searching for [" + string + "]", this));
            URL uRL = this.urlByResourceName(statusManager, string);
            if (uRL == null) {
                string = "The jndi resource [" + string + "] for context [" + loggerContext.getName() + "] does not lead to a valid file";
                statusManager.add(new WarnStatus(string, this));
            }
            return uRL;
        }
        String string2 = this.conventionalConfigFileName(var2_2.getName());
        return this.urlByResourceName(statusManager, string2);
    }

    /*
     * WARNING - void declaration
     */
    private URL urlByResourceName(StatusManager sm, String resourceName) {
        void var2_2;
        sm.add(new InfoStatus("Searching for [" + resourceName + "]", this));
        URL uRL = Loader.getResource(resourceName, Loader.getTCL());
        if (uRL != null) {
            return uRL;
        }
        return Loader.getResourceBySelfClassLoader((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void configureLoggerContextByURL(LoggerContext context, URL url) {
        void var1_1;
        try {
            void var2_2;
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            context.reset();
            joranConfigurator.setContext(context);
            joranConfigurator.doConfigure((URL)var2_2);
        }
        catch (JoranException joranException) {}
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)var1_1);
    }
}

