/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    List<String> ignoredStackTraceLines = null;
    int errorCount = 0;

    @Override
    public void start() {
        Object object = this.getFirstOption();
        if (object == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(object = ((String)object).toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(object)) {
            this.lengthOption = 1;
        } else {
            try {
                this.lengthOption = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Could not parse [" + (String)object + "] as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        object = this.getOptionList();
        if (object != null && object.size() > 1) {
            int n2 = object.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                String string = (String)object.get(i2);
                Object object2 = this.getContext();
                object2 = (Map)object2.getObject("EVALUATOR_MAP");
                if ((object2 = (EventEvaluator)object2.get(string)) != null) {
                    this.addEvaluator((EventEvaluator<ILoggingEvent>)object2);
                    continue;
                }
                this.addIgnoreStackTraceLine(string);
            }
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    private void addEvaluator(EventEvaluator<ILoggingEvent> ee) {
        void var1_1;
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add((EventEvaluator<ILoggingEvent>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addIgnoreStackTraceLine(String ignoredStackTraceLine) {
        void var1_1;
        if (this.ignoredStackTraceLines == null) {
            this.ignoredStackTraceLines = new ArrayList<String>();
        }
        this.ignoredStackTraceLines.add((String)var1_1);
    }

    @Override
    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder builder, StackTraceElementProxy step) {
    }

    @Override
    public String convert(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            boolean bl = true;
            for (int i2 = 0; i2 < this.evaluatorList.size(); ++i2) {
                Object object = this.evaluatorList.get(i2);
                try {
                    if (!object.evaluate((ILoggingEvent)event)) continue;
                    bl = false;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + object.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    object = new ErrorStatus("Exception thrown for evaluator named [" + object.getName() + "].", this, evaluationException);
                    ((StatusBase)object).add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus((Status)object);
                }
            }
            if (!bl) {
                return "";
            }
        }
        return this.throwableProxyToString(iThrowableProxy);
    }

    /*
     * WARNING - void declaration
     */
    protected String throwableProxyToString(IThrowableProxy tp) {
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder(2048);
        this.recursiveAppend(stringBuilder, null, 1, (IThrowableProxy)var1_1);
        return stringBuilder.toString();
    }

    private void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
        while (tp != null) {
            this.subjoinFirstLine(sb, (String)prefix, (int)indent, tp);
            sb.append(CoreConstants.LINE_SEPARATOR);
            this.subjoinSTEPArray(sb, (int)indent, tp);
            IThrowableProxy[] iThrowableProxyArray = tp.getSuppressed();
            if (iThrowableProxyArray != null) {
                IThrowableProxy[] iThrowableProxyArray2 = iThrowableProxyArray;
                int n2 = iThrowableProxyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    IThrowableProxy iThrowableProxy = iThrowableProxyArray2[i2];
                    this.recursiveAppend(sb, "Suppressed: ", (int)(indent + true), iThrowableProxy);
                }
            }
            tp = tp.getCause();
            String string = "Caused by: ";
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp) {
        void var1_1;
        void var3_3;
        ThrowableProxyUtil.indent(buf, (int)(var3_3 - true));
        if (prefix != null) {
            void var2_2;
            buf.append((String)var2_2);
        }
        this.subjoinExceptionMessage((StringBuilder)var1_1, tp);
    }

    /*
     * WARNING - void declaration
     */
    private void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        void var2_2;
        buf.append(tp.getClassName()).append(": ").append(var2_2.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    protected void subjoinSTEPArray(StringBuilder buf, int indent, IThrowableProxy tp) {
        int n2;
        StackTraceElementProxy[] stackTraceElementProxyArray = tp.getStackTraceElementProxyArray();
        int n3 = tp.getCommonFrames();
        boolean bl = this.lengthOption > stackTraceElementProxyArray.length;
        int n4 = n2 = bl ? stackTraceElementProxyArray.length : this.lengthOption;
        if (n3 > 0 && bl) {
            n2 -= n3;
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i2];
            if (!this.isIgnoredStackTraceLine(stackTraceElementProxy.toString())) {
                ThrowableProxyUtil.indent(buf, indent);
                this.printStackLine(buf, n5, stackTraceElementProxy);
                n5 = 0;
                buf.append(CoreConstants.LINE_SEPARATOR);
                continue;
            }
            ++n5;
            if (n2 >= stackTraceElementProxyArray.length) continue;
            ++n2;
        }
        if (n5 > 0) {
            this.printIgnoredCount(buf, n5);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n3 > 0 && bl) {
            void var3_3;
            void var1_1;
            void var2_2;
            ThrowableProxyUtil.indent(buf, (int)var2_2);
            var1_1.append("... ").append(var3_3.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printStackLine(StringBuilder buf, int ignoredCount, StackTraceElementProxy element) {
        void var3_3;
        buf.append(element);
        this.extraData(buf, (StackTraceElementProxy)var3_3);
        if (ignoredCount > 0) {
            void var2_2;
            void var1_1;
            this.printIgnoredCount((StringBuilder)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printIgnoredCount(StringBuilder buf, int ignoredCount) {
        void var2_2;
        buf.append(" [").append((int)var2_2).append(" skipped]");
    }

    private boolean isIgnoredStackTraceLine(String line) {
        if (this.ignoredStackTraceLines != null) {
            for (String string : this.ignoredStackTraceLines) {
                if (!line.contains(string)) continue;
                return true;
            }
        }
        return false;
    }
}

