/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator
implements Abbreviator {
    final int targetLength;

    /*
     * WARNING - void declaration
     */
    public TargetLengthBasedClassNameAbbreviator(int targetLength) {
        void var1_1;
        this.targetLength = var1_1;
    }

    @Override
    public String abbreviate(String fqClassName) {
        StringBuilder stringBuilder = new StringBuilder(this.targetLength);
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int n2 = fqClassName.length();
        if (n2 < this.targetLength) {
            return fqClassName;
        }
        int[] nArray = new int[16];
        int[] nArray2 = new int[17];
        int n3 = TargetLengthBasedClassNameAbbreviator.computeDotIndexes(fqClassName, nArray);
        if (n3 == 0) {
            return fqClassName;
        }
        this.computeLengthArray(fqClassName, nArray, nArray2, n3);
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (i2 == 0) {
                stringBuilder.append(fqClassName.substring(0, nArray2[i2] - 1));
                continue;
            }
            stringBuilder.append(fqClassName.substring(nArray[i2 - 1], nArray[i2 - 1] + nArray2[i2]));
        }
        return stringBuilder.toString();
    }

    static int computeDotIndexes(String className, int[] dotArray) {
        int n2;
        int n3 = 0;
        for (n2 = 0; (n3 = className.indexOf(46, n3)) != -1 && n2 < 16; ++n2) {
            dotArray[n2] = n3++;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        void var2_2;
        void var1_1;
        int n2;
        int n3 = className.length() - this.targetLength;
        for (n2 = 0; n2 < dotCount; ++n2) {
            int n4 = -1;
            if (n2 > 0) {
                n4 = dotArray[n2 - 1];
            }
            int n5 = dotArray[n2] - n4 - 1;
            n4 = n3 > 0 ? (n5 <= 0 ? n5 : 1) : n5;
            n3 -= n5 - n4;
            lengthArray[n2] = n4 + 1;
        }
        n2 = dotCount - 1;
        var3_3[dotCount] = var1_1.length() - var2_2[n2];
    }
}

