/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Iterator;
import java.util.Map;

public class MDCConverter
extends ClassicConverter {
    private String key;
    private String defaultValue = "";

    @Override
    public void start() {
        String[] stringArray = OptionHelper.extractDefaultReplacement(this.getFirstOption());
        this.key = stringArray[0];
        if (stringArray[1] != null) {
            this.defaultValue = stringArray[1];
        }
        super.start();
    }

    @Override
    public void stop() {
        this.key = null;
        super.stop();
    }

    @Override
    public String convert(ILoggingEvent event) {
        Map<String, String> map = event.getMDCPropertyMap();
        if (map == null) {
            return this.defaultValue;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys(map);
        }
        if ((map = map.get(this.key)) != null) {
            return map;
        }
        return this.defaultValue;
    }

    private String outputMDCForAllKeys(Map<String, String> mdcPropertyMap) {
        Iterator iterator;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry entry : iterator.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return stringBuilder.toString();
    }
}

