/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    CachingDateFormatter cachingDateFormatter = null;

    @Override
    public void start() {
        Object object = this.getFirstOption();
        if (object == null) {
            object = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (((String)object).equals("ISO8601")) {
            object = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + (String)object, illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List<String> list = this.getOptionList();
        if (list != null && list.size() > 1) {
            object = TimeZone.getTimeZone(list.get(1));
            this.cachingDateFormatter.setTimeZone((TimeZone)object);
        }
    }

    @Override
    public String convert(ILoggingEvent le) {
        long l2 = le.getTimeStamp();
        return this.cachingDateFormatter.format(l2);
    }
}

