/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;

public class LoggerContext
extends ContextBase
implements LifeCycle,
ILoggerFactory {
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private final List<LoggerContextListener> loggerContextListenerList = new ArrayList<LoggerContextListener>();
    private Map<String, Logger> loggerCache;
    private LoggerContextVO loggerContextRemoteView;
    private final TurboFilterList turboFilterList = new TurboFilterList();
    private boolean packagingDataEnabled = false;
    private int maxCallerDataDepth = 8;
    int resetCount = 0;
    private List<String> frameworkPackages;

    public LoggerContext() {
        this.loggerCache = new ConcurrentHashMap<String, Logger>();
        this.loggerContextRemoteView = new LoggerContextVO(this);
        this.root = new Logger("ROOT", null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put("ROOT", this.root);
        this.initEvaluatorMap();
        this.size = 1;
        this.frameworkPackages = new ArrayList<String>();
    }

    void initEvaluatorMap() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    private void updateLoggerContextVO() {
        this.loggerContextRemoteView = new LoggerContextVO(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setName(String name) {
        void var1_1;
        super.setName((String)var1_1);
        this.updateLoggerContextVO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Logger getLogger(String name) {
        int n2;
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if ("ROOT".equalsIgnoreCase(name)) {
            return this.root;
        }
        int n3 = 0;
        Logger logger = this.root;
        Logger logger2 = this.loggerCache.get(name);
        if (logger2 != null) {
            return logger2;
        }
        do {
            String string = (n2 = LoggerNameUtil.getSeparatorIndexOf(name, n3)) == -1 ? name : name.substring(0, n2);
            n3 = n2 + 1;
            Logger logger3 = logger;
            synchronized (logger3) {
                logger2 = logger.getChildByName(string);
                if (logger2 == null) {
                    logger2 = logger.createChildByName(string);
                    this.loggerCache.put(string, logger2);
                    this.incSize();
                }
            }
            logger = logger2;
        } while (n2 != -1);
        return logger2;
    }

    private void incSize() {
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            void var1_1;
            this.getStatusManager().add(new WarnStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", var1_1));
        }
    }

    public LoggerContextVO getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    @Override
    public void reset() {
        ++this.resetCount;
        super.reset();
        this.initEvaluatorMap();
        this.initCollisionMaps();
        this.root.recursiveReset();
        this.resetTurboFilterList();
        this.cancelScheduledTasks();
        this.fireOnReset();
        this.resetListenersExceptResetResistant();
        this.resetStatusListeners();
    }

    private void cancelScheduledTasks() {
        for (ScheduledFuture scheduledFuture : this.scheduledFutures) {
            scheduledFuture.cancel(false);
        }
        this.scheduledFutures.clear();
    }

    private void resetStatusListeners() {
        StatusManager statusManager = this.getStatusManager();
        for (StatusListener statusListener : statusManager.getCopyOfStatusListenerList()) {
            statusManager.remove(statusListener);
        }
    }

    public void resetTurboFilterList() {
        for (TurboFilter turboFilter : this.turboFilterList) {
            turboFilter.stop();
        }
        this.turboFilterList.clear();
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_0_3OrMore(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, params, t2);
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_1(Marker marker, Logger logger, Level level, String format, Object param, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, new Object[]{param}, t2);
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_2(Marker marker, Logger logger, Level level, String format, Object param1, Object param2, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, new Object[]{param1, param2}, t2);
    }

    private void resetListenersExceptResetResistant() {
        ArrayList<LoggerContextListener> arrayList = new ArrayList<LoggerContextListener>();
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            if (!loggerContextListener.isResetResistant()) continue;
            arrayList.add(loggerContextListener);
        }
        this.loggerContextListenerList.retainAll(arrayList);
    }

    private void resetAllListeners() {
        this.loggerContextListenerList.clear();
    }

    void fireOnLevelChange(Logger logger, Level level) {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onLevelChange(logger, level);
        }
    }

    private void fireOnReset() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onReset(this);
        }
    }

    private void fireOnStart() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onStart(this);
        }
    }

    private void fireOnStop() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onStop(this);
        }
    }

    @Override
    public void start() {
        super.start();
        this.fireOnStart();
    }

    @Override
    public void stop() {
        this.reset();
        this.fireOnStop();
        this.resetAllListeners();
        super.stop();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    public List<String> getFrameworkPackages() {
        return this.frameworkPackages;
    }
}

