/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public final class Logger
implements Serializable,
org.slf4j.Logger,
LocationAwareLogger {
    public static final String FQCN = Logger.class.getName();
    private String name;
    private transient Level level;
    private transient int effectiveLevelInt;
    private transient Logger parent;
    private transient List<Logger> childrenList;
    private transient AppenderAttachableImpl<ILoggingEvent> aai;
    private transient boolean additive = true;
    final transient LoggerContext loggerContext;

    /*
     * WARNING - void declaration
     */
    Logger(String name, Logger parent, LoggerContext loggerContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.parent = var2_2;
        this.loggerContext = var3_3;
    }

    public final Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    private boolean isRootLogger() {
        return this.parent == null;
    }

    final Logger getChildByName(String childName) {
        if (this.childrenList == null) {
            return null;
        }
        int n2 = this.childrenList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = this.childrenList.get(i2);
            String string = logger.getName();
            if (!childName.equals(string)) continue;
            return logger;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setLevel(Level newLevel) {
        void var1_1;
        if (this.level == newLevel) {
            return;
        }
        if (newLevel == null && this.isRootLogger()) {
            throw new IllegalArgumentException("The level of the root logger cannot be set to null");
        }
        this.level = newLevel;
        if (newLevel == null) {
            this.effectiveLevelInt = this.parent.effectiveLevelInt;
            newLevel = this.parent.getEffectiveLevel();
        } else {
            this.effectiveLevelInt = newLevel.levelInt;
        }
        if (this.childrenList != null) {
            int n2 = this.childrenList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Logger logger = this.childrenList.get(i2);
                logger.handleParentLevelChange(this.effectiveLevelInt);
            }
        }
        this.loggerContext.fireOnLevelChange(this, (Level)var1_1);
    }

    private synchronized void handleParentLevelChange(int newParentLevelInt) {
        if (this.level == null) {
            this.effectiveLevelInt = newParentLevelInt;
            if (this.childrenList != null) {
                int n2 = this.childrenList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Logger logger = this.childrenList.get(i2);
                    logger.handleParentLevelChange(newParentLevelInt);
                }
            }
        }
    }

    public final void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAppender(Appender<ILoggingEvent> newAppender) {
        void var1_1;
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender((Appender<ILoggingEvent>)var1_1);
    }

    public final void callAppenders(ILoggingEvent event) {
        int n2 = 0;
        Logger logger = this;
        while (logger != null) {
            n2 += logger.appendLoopOnAppenders(event);
            if (!logger.additive) break;
            logger = logger.parent;
        }
        if (n2 == 0) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int appendLoopOnAppenders(ILoggingEvent event) {
        if (this.aai != null) {
            void var1_1;
            return this.aai.appendLoopOnAppenders((ILoggingEvent)var1_1);
        }
        return 0;
    }

    private void localLevelReset() {
        this.effectiveLevelInt = 10000;
        if (this.isRootLogger()) {
            this.level = Level.DEBUG;
            return;
        }
        this.level = null;
    }

    final void recursiveReset() {
        this.detachAndStopAllAppenders();
        this.localLevelReset();
        this.additive = true;
        if (this.childrenList == null) {
            return;
        }
        for (Logger logger : this.childrenList) {
            logger.recursiveReset();
        }
    }

    final Logger createChildByName(String childName) {
        Logger logger;
        int n2 = LoggerNameUtil.getSeparatorIndexOf(childName, this.name.length() + 1);
        if (n2 != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + childName + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new CopyOnWriteArrayList<Logger>();
        }
        Logger logger2 = this;
        logger = new Logger((String)((Object)logger), logger2, logger2.loggerContext);
        this.childrenList.add(logger);
        logger.effectiveLevelInt = this.effectiveLevelInt;
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_0_Or3Plus(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, msg, params, t2);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, params, t2);
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_1(String localFQCN, Marker marker, Level level, String msg, Object param, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_1(marker, this, level, msg, param, t2);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, new Object[]{param}, t2);
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_2(String localFQCN, Marker marker, Level level, String msg, Object param1, Object param2, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_2(marker, this, level, msg, param1, param2, t2);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, new Object[]{param1, param2}, t2);
    }

    /*
     * WARNING - void declaration
     */
    private void buildLoggingEventAndAppend(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t2) {
        void var2_2;
        void var3_3;
        LoggingEvent loggingEvent;
        loggingEvent = new LoggingEvent((String)((Object)loggingEvent), this, (Level)var3_3, msg, t2, params);
        loggingEvent.setMarker((Marker)var2_2);
        this.callAppenders(loggingEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.TRACE, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.TRACE, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String msg, Throwable t2) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(Marker marker, String msg, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, null, (Throwable)var3_3);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.isDebugEnabled(null);
    }

    @Override
    public final boolean isDebugEnabled(Marker marker) {
        FilterReply filterReply;
        if ((filterReply = this.callTurboFilters((Marker)((Object)filterReply), Level.DEBUG)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 10000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.DEBUG, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.DEBUG, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String msg, Throwable t2) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(Marker marker, String msg, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, null, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.ERROR, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.ERROR, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg, Throwable t2) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(Marker marker, String msg, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, null, (Throwable)var3_3);
    }

    @Override
    public final boolean isInfoEnabled() {
        return this.isInfoEnabled(null);
    }

    @Override
    public final boolean isInfoEnabled(Marker marker) {
        FilterReply filterReply;
        if ((filterReply = this.callTurboFilters((Marker)((Object)filterReply), Level.INFO)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 20000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.INFO, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.INFO, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String msg, Throwable t2) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(Marker marker, String msg, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, null, (Throwable)var3_3);
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.isTraceEnabled(null);
    }

    @Override
    public final boolean isTraceEnabled(Marker marker) {
        FilterReply filterReply;
        if ((filterReply = this.callTurboFilters((Marker)((Object)filterReply), Level.TRACE)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 5000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.isErrorEnabled(null);
    }

    @Override
    public final boolean isErrorEnabled(Marker marker) {
        FilterReply filterReply;
        if ((filterReply = this.callTurboFilters((Marker)((Object)filterReply), Level.ERROR)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 40000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.isWarnEnabled(null);
    }

    @Override
    public final boolean isWarnEnabled(Marker marker) {
        FilterReply filterReply;
        if ((filterReply = this.callTurboFilters((Marker)((Object)filterReply), Level.WARN)) == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 30000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String msg, Throwable t2) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.WARN, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.WARN, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(Marker marker, String msg, Throwable t2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, null, (Throwable)var3_3);
    }

    public final String toString() {
        return "Logger[" + this.name + "]";
    }

    /*
     * WARNING - void declaration
     */
    private FilterReply callTurboFilters(Marker marker, Level level) {
        void var2_2;
        void var1_1;
        return this.loggerContext.getTurboFilterChainDecision_0_3OrMore((Marker)var1_1, this, (Level)var2_2, null, null, null);
    }

    public final LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void log(Marker marker, String fqcn, int levelInt, String message, Object[] argArray, Throwable t2) {
        void var1_1;
        void var2_2;
        Level level = Level.fromLocationAwareLoggerInteger(levelInt);
        this.filterAndLog_0_Or3Plus((String)var2_2, (Marker)var1_1, level, message, argArray, t2);
    }
}

