/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import java.io.Serializable;

public final class Level
implements Serializable {
    public static final Integer OFF_INTEGER = Integer.MAX_VALUE;
    public static final Integer ERROR_INTEGER = 40000;
    public static final Integer WARN_INTEGER = 30000;
    public static final Integer INFO_INTEGER = 20000;
    public static final Integer DEBUG_INTEGER = 10000;
    public static final Integer TRACE_INTEGER = 5000;
    public static final Integer ALL_INTEGER = Integer.MIN_VALUE;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF");
    public static final Level ERROR = new Level(40000, "ERROR");
    public static final Level WARN = new Level(30000, "WARN");
    public static final Level INFO = new Level(20000, "INFO");
    public static final Level DEBUG = new Level(10000, "DEBUG");
    public static final Level TRACE = new Level(5000, "TRACE");
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL");
    public final int levelInt;
    public final String levelStr;

    /*
     * WARNING - void declaration
     */
    private Level(int levelInt, String levelStr) {
        void var2_2;
        void var1_1;
        this.levelInt = var1_1;
        this.levelStr = var2_2;
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.levelInt;
    }

    public static Level toLevel(int val) {
        return Level.toLevel(val, DEBUG);
    }

    /*
     * WARNING - void declaration
     */
    public static Level toLevel(int val, Level defaultLevel) {
        void var1_1;
        switch (val) {
            case -2147483648: {
                return ALL;
            }
            case 5000: {
                return TRACE;
            }
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        return var1_1;
    }

    public static Level fromLocationAwareLoggerInteger(int levelInt) {
        Level level;
        switch (levelInt) {
            case 0: {
                level = TRACE;
                break;
            }
            case 10: {
                level = DEBUG;
                break;
            }
            case 20: {
                level = INFO;
                break;
            }
            case 30: {
                level = WARN;
                break;
            }
            case 40: {
                level = ERROR;
                break;
            }
            default: {
                int n2;
                throw new IllegalArgumentException(n2 + " not a valid level value");
            }
        }
        return level;
    }
}

